/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.lang;

import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringNumberComparator
implements Comparator<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(StringNumberComparator.class);

    @Override
    public final int compare(Object obj1, Object obj2) {
        return StringNumberComparator.compareAsDouble(obj1, obj2);
    }

    public static final int compareAsDouble(Object obj1, Object obj2) {
        double value2;
        double value1 = StringNumberComparator.getDoubleValue(obj1);
        if (value1 > (value2 = StringNumberComparator.getDoubleValue(obj2))) {
            return 1;
        }
        if (value1 < value2) {
            return -1;
        }
        return 0;
    }

    public static final double getDoubleValue(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        String strObj = obj.toString();
        double dblNum = 0.0;
        for (int i = 0; i < strObj.length(); ++i) {
            String strNum = strObj.substring(0, strObj.length() - i);
            try {
                dblNum = Double.parseDouble(strNum);
                break;
            }
            catch (NumberFormatException e) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace(String.format("'%s' is not a number: %s", strNum, e.getMessage()));
                continue;
            }
        }
        return dblNum;
    }
}

