/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc;

import de.riwagis.util.jdbc.JDBCDBMetaInterface;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SavedJDBCDBConnectionEntry
implements Serializable,
Comparable<SavedJDBCDBConnectionEntry> {
    public static final String WB_DEFAULT_DBLOGINDIALOG_SAVEDCONNECTIONS = "DBLoginDialog.savedConnections";
    public static final ListCellRenderer DEFAULT_LISTRENDERER = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return super.getListCellRendererComponent((JList<?>)list, "", index, isSelected, cellHasFocus);
            }
            SavedJDBCDBConnectionEntry entry = (SavedJDBCDBConnectionEntry)value;
            return super.getListCellRendererComponent((JList<?>)list, String.format("%s ('%s', User: '%s')", entry.getConnectionName(), entry.getDbMeta().getDBUrl(), entry.getDbMeta().getUsername()), index, isSelected, cellHasFocus);
        }
    };
    private final JDBCDBMetaInterface dbMeta;
    private final String connectionName;

    public static final List<SavedJDBCDBConnectionEntry> emptyList() {
        return new ArrayList<SavedJDBCDBConnectionEntry>();
    }

    public SavedJDBCDBConnectionEntry(String _connectionName, JDBCDBMetaInterface _dbMeta) {
        this.dbMeta = _dbMeta;
        this.connectionName = _connectionName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public JDBCDBMetaInterface getDbMeta() {
        return this.dbMeta;
    }

    public String toString() {
        return String.format("SavedJDBCDBConnectionEntry '%s' (JDBCDBMeta: %s)", this.connectionName, this.dbMeta);
    }

    public boolean equals(Object obj) {
        boolean res;
        boolean bl = res = obj != null && obj instanceof SavedJDBCDBConnectionEntry;
        if (res) {
            SavedJDBCDBConnectionEntry entry = (SavedJDBCDBConnectionEntry)obj;
            res = StringUtils.equals((CharSequence)this.getConnectionName(), (CharSequence)entry.getConnectionName()) && ObjectUtils.equals((Object)this.getDbMeta(), (Object)entry.getDbMeta());
        }
        return res;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Override
    public int compareTo(SavedJDBCDBConnectionEntry o) {
        return this.toString().compareTo(o == null ? "" : o.toString());
    }

    public boolean isBlank() {
        return StringUtils.isBlank((CharSequence)this.getConnectionName()) && (this.getDbMeta() == null || this.getDbMeta().isBlank());
    }
}

