/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc;

import de.riwagis.util.jdbc.AbstractJDBCDBMeta;
import de.riwagis.util.jdbc.JDBCDBMetaInterface;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class JDBCDBMeta
extends AbstractJDBCDBMeta
implements Cloneable {
    private String strUsername = "";
    private String strPassword = "";
    private String strDBService = "";
    private String strDBUrl = "";
    private String strDBDriver = "";
    private String strDBType = "";
    private boolean bolReadonly = false;
    private final Map<Object, Object> mapParameters = new HashMap<Object, Object>();

    public JDBCDBMeta() {
    }

    public JDBCDBMeta(String _strDBDriver, String _strDBUrl, String _strUsername, String _strPassword, String _strDBService) {
        this.strDBDriver = _strDBDriver;
        this.strDBUrl = _strDBUrl;
        this.strUsername = _strUsername;
        this.strPassword = _strPassword;
        this.strDBService = _strDBService;
    }

    public JDBCDBMeta(JDBCDBMeta _meta) {
        this(_meta.getDBDriver(), _meta.getDBUrl(), _meta.getUsername(), _meta.getPassword(), _meta.getDBService());
        this.strDBType = _meta.getDBType();
        this.bolReadonly = _meta.getReadonly();
        this.setParameters(_meta.getParameters());
    }

    @Override
    public String getUsername() {
        return this.strUsername;
    }

    public Object clone() throws CloneNotSupportedException {
        JDBCDBMeta newObj = (JDBCDBMeta)super.clone();
        newObj.setParameters(this.mapParameters);
        return newObj;
    }

    public void setUsername(String _strUsername) {
        this.strUsername = _strUsername;
    }

    @Override
    public String getPassword() {
        return this.strPassword;
    }

    public void setPassword(String _strPassword) {
        this.strPassword = _strPassword;
    }

    @Override
    public String getDBService() {
        return this.strDBService;
    }

    public void setDBService(String _strDBService) {
        this.strDBService = _strDBService;
    }

    @Override
    public String getDBUrl() {
        return this.strDBUrl;
    }

    public void setDBUrl(String _strDBUrl) {
        this.strDBUrl = _strDBUrl;
    }

    @Override
    public String getDBDriver() {
        return this.strDBDriver;
    }

    public void setDBDriver(String _strDBDriver) {
        this.strDBDriver = _strDBDriver;
    }

    public String getDBType() {
        return this.strDBType;
    }

    public void setDBType(String _strDBType) {
        this.strDBType = (String)StringUtils.defaultIfEmpty((CharSequence)_strDBType, (CharSequence)"-1");
    }

    public boolean getReadonly() {
        return this.bolReadonly;
    }

    public void setReadonly(boolean _bolReadonly) {
        this.bolReadonly = _bolReadonly;
    }

    public Object getParameter(Object key) {
        return this.mapParameters.get(key);
    }

    public void putParameter(Object key, Object value) {
        this.mapParameters.put(key, value);
    }

    public Object removeParameter(Object key) {
        return this.mapParameters.remove(key);
    }

    @Override
    public String toString() {
        return ("User: " + this.getUsername() + " Url: " + this.getDBUrl() + " Driver: " + this.getDBDriver() + " Write: " + this.getReadonly()).toUpperCase();
    }

    private void setParameters(Map<Object, Object> mapParameters) {
        this.mapParameters.clear();
        this.mapParameters.putAll(mapParameters);
    }

    private Map<Object, Object> getParameters() {
        return Collections.unmodifiableMap(this.mapParameters);
    }

    public void fillFromInterface(JDBCDBMetaInterface _newDBMeta) {
        this.strDBDriver = _newDBMeta.getDBDriver();
        this.strDBUrl = _newDBMeta.getDBUrl();
        this.strUsername = _newDBMeta.getUsername();
        this.strPassword = _newDBMeta.getPassword();
        this.strDBService = _newDBMeta.getDBService();
    }
}

