/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18N {
    private static final Logger LOG = LoggerFactory.getLogger(I18N.class);
    public static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private final ResourceBundle bundle;

    public I18N(Locale loc, String strBundle) {
        this.bundle = this.getResourceBundle(strBundle, loc);
    }

    public I18N(String strLocale, String strBundle) {
        this(I18N.getLocale(strLocale), strBundle);
    }

    private ResourceBundle getResourceBundle(String bundle_name, Locale loc) {
        try {
            return ResourceBundle.getBundle(bundle_name, loc);
        }
        catch (MissingResourceException e) {
            Locale newLoc = new Locale(loc.getLanguage());
            LOG.trace(String.format("ResourceBundle '%s' not found for locale '%s'. Using backup locale '%s'.", bundle_name, loc, newLoc), (Throwable)e);
            try {
                return ResourceBundle.getBundle(bundle_name, newLoc);
            }
            catch (MissingResourceException e1) {
                LOG.trace(String.format("ResourceBundle '%s' not found for locale '%s'. Using root locale '%s'.", bundle_name, loc, Locale.ROOT), (Throwable)e1);
                return ResourceBundle.getBundle(bundle_name, Locale.ROOT);
            }
        }
    }

    public static Locale getLocale(String strLocaleAsString) {
        if (StringUtils.isBlank((CharSequence)strLocaleAsString)) {
            return DEFAULT_LOCALE;
        }
        String[] arrLocale = strLocaleAsString.split("_");
        if (arrLocale.length == 1) {
            return new Locale(arrLocale[0]);
        }
        return new Locale(arrLocale[0], arrLocale[1]);
    }

    public String get(String strKey) {
        String strText = null;
        try {
            strText = this.bundle.getString(strKey);
        }
        catch (Exception e) {
            LOG.warn(String.format("Unknown I18N Key: %s", strKey), (Throwable)e);
        }
        return StringUtils.defaultString((String)strText, (String)("!" + strKey));
    }

    public String fmt(String strKey, Object ... arguments) {
        return MessageFormat.format(this.get(strKey), arguments);
    }
}

