/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.exception;

import org.apache.commons.lang3.StringUtils;

public class SystemException
extends Exception {
    protected static final String KEINE_FEHLERMELDUNG = "[]";
    private final Class<?> callingClass;
    private final String methodName;

    public SystemException(Class<?> callingClass, String message) {
        this(callingClass, null, message);
    }

    public SystemException(Class<?> callingClass, Throwable e) {
        this(callingClass, null, StringUtils.defaultString((String)(e != null ? e.getMessage() : null), (String)KEINE_FEHLERMELDUNG), e);
    }

    public SystemException(Class<?> callingClass, String message, Throwable e) {
        this(callingClass, null, message, e);
    }

    public SystemException(Class<?> callingClass, String methodName, String message) {
        this(callingClass, methodName, message, null);
    }

    public SystemException(Class<?> callingClass, String methodName, String message, Throwable t) {
        super(message, t);
        this.callingClass = callingClass;
        this.methodName = methodName;
    }

    public SystemException(String message) {
        this(null, message);
    }

    public SystemException(Throwable e) {
        this((Class)null, e);
    }

    public SystemException(String message, Throwable e) {
        this(null, message, e);
    }

    public String getOnlyMessage() {
        String location = this.getLocation();
        Throwable cause = this.getCause();
        return (String)(StringUtils.isBlank((CharSequence)location) ? "" : location + ": ") + StringUtils.defaultString((String)super.getMessage(), (String)(cause == null ? KEINE_FEHLERMELDUNG : cause.getMessage()));
    }

    public Class<?> getCallingClass() {
        return this.callingClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String toString() {
        return this.formattedMessage();
    }

    public final String formattedMessage() {
        StringBuilder res = new StringBuilder(this.getOnlyMessage());
        if (this.getCause() != null) {
            res.append("\n");
            if (this.getCause() instanceof SystemException) {
                res.append(((SystemException)this.getCause()).formattedMessage());
            } else {
                res.append(this.getCause().getMessage());
            }
        }
        return res.toString();
    }

    public String getLocation() {
        Object location = "";
        if (this.callingClass != null) {
            location = (String)location + this.callingClass.getName();
        }
        if (StringUtils.isNotBlank((CharSequence)this.methodName)) {
            location = (String)location + "/" + this.methodName;
        }
        if (StringUtils.isNotBlank((CharSequence)location)) {
            location = "@" + (String)location;
        }
        return location;
    }
}

