/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util;

import de.riwagis.util.Config;
import de.riwagis.util.DateSupport;
import de.riwagis.util.GZipSupport;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringSupport {
    private static final Logger LOG = LoggerFactory.getLogger(StringSupport.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final BaseNCodec BASE64 = new Base64();
    public static final String UTF_8 = StandardCharsets.UTF_8.name();

    private StringSupport() {
    }

    public static String shortDate2Date(String dateValue, boolean formatAsSearchRange, DateFormat dateFormat) {
        return StringSupport.shortDate2Date(dateValue, formatAsSearchRange, true, dateFormat);
    }

    public static String shortDate2Date(String dateValue, boolean formatAsSearchRange, boolean useStartOfRange, DateFormat dateFormat) {
        int year;
        boolean isDateTimeFormatter;
        String dateMatch = "(\\d{2})\\.(\\d{2})\\.(\\d{2}$|\\d{4}$)";
        String dateTimeHourMinuteMatch = "(\\d{2}).(\\d{2})\\.(\\d{2}|\\d{4})\\s(\\d{2}):(\\d{2})";
        boolean bl = isDateTimeFormatter = dateFormat instanceof SimpleDateFormat && ((SimpleDateFormat)dateFormat).toPattern().indexOf("HH:mm:ss") > 0;
        if (!StringSupport.isNumeric(dateValue) && (!isDateTimeFormatter || !dateValue.matches("(\\d{2})\\.(\\d{2})\\.(\\d{2}$|\\d{4}$)") && !dateValue.matches("(\\d{2}).(\\d{2})\\.(\\d{2}|\\d{4})\\s(\\d{2}):(\\d{2})")) || dateFormat == null) {
            return dateValue;
        }
        Calendar cal = Calendar.getInstance();
        String[] arrNums = dateValue.split(" ")[0].split("\\.");
        int month = 0;
        int day = 1;
        int lastmonth = 11;
        int lastday = 0;
        int hour = 0;
        int lastHour = 23;
        int minute = 0;
        int lastMinute = 59;
        if (arrNums.length == 1) {
            year = Integer.parseInt(arrNums[0]);
            if (year < 1000) {
                year = year > 50 && year < 100 ? (year += 1900) : (year += 2000);
            }
        } else if (arrNums.length == 2) {
            year = Integer.parseInt(arrNums[1]);
            if (year < 1000) {
                year = year > 50 && year < 100 ? (year += 1900) : (year += 2000);
            }
            lastmonth = month = Math.min(Math.max(Integer.parseInt(arrNums[0]) - 1, 0), 11);
        } else {
            year = Integer.parseInt(arrNums[2]);
            if (year < 1000) {
                year = year > 50 && year < 100 ? (year += 1900) : (year += 2000);
            }
            lastmonth = month = Math.min(Math.max(Integer.parseInt(arrNums[1]) - 1, 0), 11);
            lastday = day = Math.min(Math.max(Integer.parseInt(arrNums[0]), 1), 31);
        }
        if (dateValue.matches("(\\d{2}).(\\d{2})\\.(\\d{2}|\\d{4})\\s(\\d{2}):(\\d{2})")) {
            String[] hourMinute = dateValue.split(" ")[1].split(":");
            hour = Integer.parseInt(hourMinute[0]);
            minute = Integer.parseInt(hourMinute[1]);
            lastHour = hour;
            lastMinute = minute;
        }
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        if (isDateTimeFormatter) {
            cal.set(11, hour);
            cal.set(12, minute);
            cal.set(13, 0);
        }
        String strDate = dateFormat.format(cal.getTime());
        if (lastday == 0) {
            lastday = cal.getActualMaximum(5);
        }
        cal.set(1, year);
        cal.set(2, lastmonth);
        cal.set(5, lastday);
        if (isDateTimeFormatter) {
            cal.set(11, lastHour);
            cal.set(12, lastMinute);
            cal.set(13, 59);
        }
        String strLastDate = dateFormat.format(cal.getTime());
        if (!formatAsSearchRange) {
            if (useStartOfRange) {
                return strDate;
            }
            return strLastDate;
        }
        if (strLastDate.equals(strDate)) {
            return strDate;
        }
        return strDate + "-" + strLastDate;
    }

    public static boolean isNumeric(String tf) {
        boolean result = false;
        try {
            Double d = Double.valueOf(tf);
            result = d != null;
        }
        catch (NumberFormatException ex) {
            LOG.trace(String.format("not a number: %s", tf), (Throwable)ex);
        }
        return result;
    }

    public static String toAsciiString(String str2convert) {
        if (str2convert == null) {
            return null;
        }
        String convertedString = Normalizer.normalize(str2convert, Normalizer.Form.NFC);
        convertedString = convertedString.replaceAll("\u00fc", "ue");
        convertedString = convertedString.replaceAll("\u00f6", "oe");
        convertedString = convertedString.replaceAll("\u00e4", "ae");
        convertedString = convertedString.replaceAll("\u00df", "ss");
        convertedString = convertedString.replaceAll("\u00dc", "Ue");
        convertedString = convertedString.replaceAll("\u00d6", "Oe");
        convertedString = convertedString.replaceAll("\u00c4", "Ae");
        return convertedString;
    }

    public static String getCsvValue(String _strValue, String strDeci, String strQuote) {
        String strValue = ObjectUtils.toString((Object)_strValue);
        if (!StringSupport.isNumeric(strValue = strValue.trim()) && !StringUtils.isEmpty((CharSequence)strValue)) {
            strValue = strValue.replaceAll("&#39;", "'");
            strValue = strValue.replaceAll("\r", "");
            if (StringUtils.isNotEmpty((CharSequence)strQuote)) {
                strValue = strValue.replaceAll("\\" + strQuote, strQuote + strQuote);
            }
            return strQuote + strValue + strQuote;
        }
        strValue = strValue.replaceAll("\\.", strDeci);
        return strValue;
    }

    @Deprecated
    public static String[] readCsvLine(String strLine, char chrDelim, char chrMask, BufferedReader _bread) throws IOException {
        if (strLine == null) {
            return null;
        }
        boolean bolInMask = false;
        ArrayList<String> lstResult = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(strLine);
        StringBuilder sbResult = new StringBuilder();
        for (int i = 0; i < sb.length(); ++i) {
            char chr = sb.charAt(i);
            if (chr == chrMask) {
                if (bolInMask && i + 1 < sb.length() && chrMask == sb.charAt(i + 1)) {
                    ++i;
                    sbResult.append(String.valueOf(chrMask));
                    continue;
                }
                bolInMask = !bolInMask;
                continue;
            }
            if (chr == chrDelim) {
                if (bolInMask) {
                    sbResult.append(String.valueOf(chr));
                    continue;
                }
                lstResult.add(sbResult.toString());
                sbResult.setLength(0);
                continue;
            }
            sbResult.append(String.valueOf(chr));
        }
        lstResult.add(sbResult.toString());
        if (bolInMask) {
            String nextLine = strLine + "\n" + _bread.readLine();
            return StringSupport.readCsvLine(nextLine, chrDelim, chrMask, _bread);
        }
        return lstResult.toArray(new String[lstResult.size()]);
    }

    public static String toDelimitedString(Collection<?> lstData, String strDelim) {
        return StringSupport.toDelimitedString(lstData, strDelim, "");
    }

    public static String toDelimitedString(Collection<?> coll, String delimiter, String quote) {
        StringBuilder sbRetValue = new StringBuilder();
        for (Object content : coll) {
            if (sbRetValue.length() > 0) {
                sbRetValue.append(delimiter);
            }
            sbRetValue.append(StringSupport.quoteString(ObjectUtils.toString(content, (String)""), quote));
        }
        return sbRetValue.toString();
    }

    public static String toDelimitedString(Object[] arrData, String strDelim) {
        return StringSupport.toDelimitedString(arrData, strDelim, "");
    }

    public static String toDelimitedString(Object[] arrData, String strDelim, String quote) {
        return StringSupport.toDelimitedString(Arrays.asList(arrData), strDelim, quote);
    }

    public static byte[] toByteArray(char[] carr) {
        if (carr == null) {
            return null;
        }
        byte[] barr = new byte[carr.length];
        for (int i = 0; i < carr.length; ++i) {
            barr[i] = (byte)carr[i];
        }
        return barr;
    }

    public static char[] toCharArray(byte[] barr) {
        if (barr == null) {
            return null;
        }
        char[] carr = new char[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            carr[i] = (char)barr[i];
        }
        return carr;
    }

    public static boolean equals(char c, char[] match) {
        for (int i = 0; i < match.length; ++i) {
            if (c != match[i]) continue;
            return true;
        }
        return false;
    }

    public static int findFirstAny(char[] source, int index, char[] match) {
        for (int i = index; i < source.length; ++i) {
            if (!StringSupport.equals(source[i], match)) continue;
            return i;
        }
        return -1;
    }

    public static int getCharCount(String str, char chr) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != chr) continue;
            ++count;
        }
        return count;
    }

    public static int findFirstDiff(char[] source, int index, char[] match) {
        for (int i = index; i < source.length; ++i) {
            if (StringSupport.equals(source[i], match)) continue;
            return i;
        }
        return -1;
    }

    public static String compressString(String str) throws IOException {
        if (str != null) {
            try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
                GZipSupport.gzipStream(new ByteArrayInputStream(str.getBytes(UTF_8)), bout);
                String string = BASE64.encodeAsString(bout.toByteArray());
                return string;
            }
        }
        return null;
    }

    public static String decompressString(String str) throws IOException {
        if (str != null) {
            try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
                GZipSupport.gunzipStream(new ByteArrayInputStream(BASE64.decode(str)), bout);
                String string = new String(bout.toByteArray(), UTF_8);
                return string;
            }
        }
        return null;
    }

    public static String replace(String original, String oldSubstring, String newSubstring, boolean all) {
        StringBuilder b = new StringBuilder(original);
        StringSupport.replace(b, oldSubstring, newSubstring, all);
        return b.toString();
    }

    public static void replace(StringBuilder original, String oldSubstring, String newSubstring, boolean all) {
        if (original == null || oldSubstring == null || oldSubstring.length() == 0 || newSubstring == null) {
            throw new IllegalArgumentException("Null or zero-length String");
        }
        int i = 0;
        while (i + oldSubstring.length() <= original.length()) {
            if (original.substring(i, i + oldSubstring.length()).equals(oldSubstring)) {
                original.replace(i, i + oldSubstring.length(), newSubstring);
                if (!all) break;
                i += newSubstring.length();
                continue;
            }
            ++i;
        }
    }

    @Deprecated
    public static String toString(java.util.Date date) {
        return DateSupport.toString(date);
    }

    @Deprecated
    public static String toString(Date date) {
        return DateSupport.toString(date);
    }

    public static String toString(double dblNum, int decPlaces) {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Config.LOCALE);
        df.setGroupingUsed(false);
        df.setMaximumFractionDigits(decPlaces);
        df.setMinimumFractionDigits(decPlaces);
        return df.format(dblNum);
    }

    public static String addLeadingDot(String fileExtension) {
        if (StringUtils.isNotBlank((CharSequence)fileExtension) && !fileExtension.startsWith(".")) {
            return "." + fileExtension;
        }
        return fileExtension;
    }

    public static String changeExtension(String originalName, String newExtension, String separator) {
        if (originalName != null && newExtension != null) {
            int lastDot = originalName.lastIndexOf(46);
            int lastSep = originalName.lastIndexOf(separator);
            if (lastDot != -1 && lastDot > lastSep) {
                return originalName.substring(0, lastDot) + StringSupport.addLeadingDot(newExtension);
            }
            return originalName + StringSupport.addLeadingDot(newExtension);
        }
        return originalName;
    }

    public static File changeExtension(File originalFile, String newExtension) {
        if (originalFile != null) {
            return new File(StringSupport.changeExtension(originalFile.getPath(), newExtension, File.separator));
        }
        return originalFile;
    }

    public static String quoteString(String original, String quoteChar, String escapedQuoteChar) {
        if (quoteChar == null || escapedQuoteChar == null) {
            throw new NullPointerException("quotation with NULL quotation not allowed");
        }
        if (original != null && quoteChar.length() > 0) {
            String regexQuoteChar = quoteChar.replaceAll("(.)", "\\\\$1");
            String replaceQuoteChar = escapedQuoteChar.replaceAll("\\\\", "\\\\\\\\");
            return quoteChar + original.replaceAll(regexQuoteChar, replaceQuoteChar) + quoteChar;
        }
        return original;
    }

    public static String quoteString(String original, String quoteChar) {
        return StringSupport.quoteString(original, quoteChar, quoteChar + quoteChar);
    }

    public static final boolean containsIgnoreCase(Collection<String> strings, String value) {
        boolean res = false;
        for (String currString : strings) {
            res |= StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)currString);
        }
        return res;
    }

    public static final int indexOfIgnoreCase(List<String> strings, String value) {
        int res = -1;
        for (int i = 0; i < strings.size() && res == -1; ++i) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)strings.get(i))) continue;
            res = i;
        }
        return res;
    }

    public static final int indexOfIgnoreCase(String[] stringArray, String value) {
        return StringSupport.indexOfIgnoreCase(Arrays.asList(stringArray), value);
    }

    public static String[] toArray(Collection<String> strings) {
        if (strings != null) {
            return strings.toArray(EMPTY_STRING_ARRAY);
        }
        return null;
    }
}

