/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;

public class PropertiesSupport {
    public static final Charset DEFAULT_PROPERTIES_ENCODING = StandardCharsets.ISO_8859_1;

    public static void saveProperties(Properties p, File propertiesFile) throws IOException {
        try (FileOutputStream os = new FileOutputStream(propertiesFile);){
            p.store(os, "Defaults");
        }
    }

    public static void loadProperties(Properties properties, File propertyFile) throws IOException {
        PropertiesSupport.loadProperties(properties, propertyFile, DEFAULT_PROPERTIES_ENCODING);
    }

    public static void loadProperties(Properties properties, File propertiesFile, Charset encoding) throws IOException {
        File tmpFile = Objects.requireNonNull(propertiesFile, "propertiesFile must not be null");
        Charset tmpEncoding = Objects.requireNonNull(encoding, "encoding must not be null");
        Properties tmpProperties = Objects.requireNonNull(properties, "properties must not be null");
        try (FileInputStream is = new FileInputStream(tmpFile);){
            PropertiesSupport.loadProperties(tmpProperties, is, tmpEncoding);
        }
    }

    public static Properties loadProperties(File propertiesFile) throws IOException {
        return PropertiesSupport.loadProperties(propertiesFile, DEFAULT_PROPERTIES_ENCODING);
    }

    public static Properties loadProperties(InputStream is) throws IOException {
        return PropertiesSupport.loadProperties(is, DEFAULT_PROPERTIES_ENCODING);
    }

    public static Properties loadProperties(InputStream is, Charset encoding) throws IOException {
        Properties properties = new Properties();
        PropertiesSupport.loadProperties(properties, is, encoding);
        return properties;
    }

    public static void loadProperties(Properties properties, InputStream is, Charset encoding) throws IOException {
        InputStream tmpIS = Objects.requireNonNull(is, "is must not be null");
        try (InputStreamReader propertiesReader = new InputStreamReader(tmpIS, encoding);){
            properties.load(propertiesReader);
        }
    }

    public static Properties loadPropertiesFromResource(String propertiesResource) throws IOException {
        return PropertiesSupport.loadPropertiesFromResource(PropertiesSupport.class, propertiesResource);
    }

    public static Properties loadPropertiesFromResource(Class<?> aClass, String propertiesResource) throws IOException {
        return PropertiesSupport.loadPropertiesFromResource(aClass, propertiesResource, DEFAULT_PROPERTIES_ENCODING);
    }

    public static Properties loadPropertiesFromResource(String propertiesResource, Charset encoding) throws IOException {
        return PropertiesSupport.loadPropertiesFromResource(PropertiesSupport.class, propertiesResource, encoding);
    }

    public static Properties loadPropertiesFromResource(Class<?> aClass, String propertiesResource, Charset encoding) throws IOException {
        Class<?> tmpClass = Objects.requireNonNull(aClass, "class must not be null");
        String tmpPropertiesResource = Objects.requireNonNull(propertiesResource, "propertiesresource must not be null");
        Charset tmpEncoding = Objects.requireNonNull(encoding, "encoding must not be null");
        try (InputStream propertiesStream = tmpClass.getResourceAsStream(tmpPropertiesResource);){
            Properties properties = PropertiesSupport.loadProperties(propertiesStream, tmpEncoding);
            return properties;
        }
    }

    public static Properties loadProperties(File propertiesFile, Charset encoding) throws IOException {
        Properties p = new Properties();
        PropertiesSupport.loadProperties(p, propertiesFile, encoding);
        return p;
    }

    public static void storeProperties(Properties properties, File propertyFile, String comments) throws IOException {
        PropertiesSupport.storeProperties(properties, propertyFile, comments, DEFAULT_PROPERTIES_ENCODING);
    }

    public static void storeProperties(Properties properties, File propertyFile, String comments, Charset encoding) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(propertyFile);
             OutputStreamWriter wr = new OutputStreamWriter((OutputStream)fos, encoding);){
            properties.store(wr, comments);
        }
    }

    public static void storeProperties(Properties properties, File propertyFile) throws IOException {
        PropertiesSupport.storeProperties(properties, propertyFile, DEFAULT_PROPERTIES_ENCODING);
    }

    public static void storeProperties(Properties properties, File propertyFile, Charset encoding) throws IOException {
        PropertiesSupport.storeProperties(properties, propertyFile, "", encoding);
    }

    private PropertiesSupport() {
    }
}

