/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util;

import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberSupport {
    private static final Logger LOG = LoggerFactory.getLogger(NumberSupport.class);

    public static final Double asDouble(Object val) {
        try {
            if (val == null) {
                return null;
            }
            if (val instanceof Double) {
                return (Double)val;
            }
            if (val instanceof Number) {
                return ((Number)val).doubleValue();
            }
            if (val instanceof String) {
                return StringUtils.isBlank((CharSequence)((String)val)) ? null : Double.valueOf(Double.parseDouble(StringUtils.trim((String)((String)val))));
            }
        }
        catch (Exception x) {
            LOG.trace(String.format("exception occured: %s", x.getMessage()), (Throwable)x);
        }
        throw new IllegalArgumentException(String.format("not a floatingpoint number: %s", val));
    }

    public static final Integer asInteger(Object val) {
        try {
            if (val == null) {
                return null;
            }
            if (val instanceof Integer) {
                return (Integer)val;
            }
            if (val instanceof BigDecimal) {
                return ((BigDecimal)val).intValueExact();
            }
            if (val instanceof Number) {
                return ((Number)val).intValue();
            }
            if (val instanceof String) {
                return StringUtils.isBlank((CharSequence)((String)val)) ? null : Integer.valueOf(Integer.parseInt(StringUtils.trim((String)((String)val))));
            }
        }
        catch (Exception x) {
            LOG.trace(String.format("exception occured: %s", x.getMessage()), (Throwable)x);
        }
        throw new IllegalArgumentException(String.format("not an integer number: %s", val));
    }

    private NumberSupport() {
    }
}

