/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipSupport {
    public static final int COPY_BUFSIZE = 512;
    public static final int EOF = -1;

    public static void gzipStream(InputStream uncompressedIn, OutputStream compressedOut) throws IOException {
        try (GZIPOutputStream gzipStream = new GZIPOutputStream(compressedOut);){
            GZipSupport.copyStream(uncompressedIn, gzipStream);
        }
    }

    public static void gunzipStream(InputStream compressedIn, OutputStream compressedOut) throws IOException {
        try (GZIPInputStream gzipStream = new GZIPInputStream(compressedIn);){
            GZipSupport.copyStream(gzipStream, compressedOut);
        }
    }

    @Deprecated
    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] data = new byte[512];
        while ((count = in.read(data, 0, data.length)) != -1) {
            out.write(data, 0, count);
        }
    }

    private GZipSupport() {
    }
}

