/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util;

import de.riwagis.util.Config;
import java.text.DateFormat;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public final class DateSupport {
    public static final String DF_DDMMYYYY_STR = "dd.MM.yyyy";
    public static final FastDateFormat DF_DDMMYYYY = FastDateFormat.getInstance((String)"dd.MM.yyyy");

    public static final String formatDDMMYYYY(Date d) {
        return DateSupport.formatDDMMYYYY(d, "");
    }

    public static final String formatDDMMYYYY(Date d, String defaultValue) {
        if (d != null) {
            return DF_DDMMYYYY.format(d);
        }
        return defaultValue;
    }

    public static final Date truncDate(Date theDate) {
        return DateSupport.truncDate(theDate, 0);
    }

    public static final Date truncDate(Date theDate, int dayOffset) {
        if (theDate != null) {
            Date resDate = DateUtils.truncate((Date)theDate, (int)5);
            resDate = DateUtils.addDays((Date)resDate, (int)dayOffset);
            return resDate;
        }
        return null;
    }

    public static final boolean isInDayRange(Date testDate, Date fromDate, Date toDate) {
        boolean res = false;
        if (testDate != null) {
            Date fromDateTrunc = DateSupport.truncDate(fromDate);
            Date toDateTrunc = DateSupport.truncDate(toDate, 1);
            res = !(fromDateTrunc != null && fromDateTrunc.getTime() > testDate.getTime() || toDateTrunc != null && toDateTrunc.getTime() <= testDate.getTime());
        }
        return res;
    }

    public static final Date copyDate(Date date) {
        return date == null ? null : new Date(date.getTime());
    }

    public static String toString(Date date) {
        return date == null ? "" : DateFormat.getDateInstance(2, Config.LOCALE).format(date);
    }

    private DateSupport() {
    }
}

