/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.validation;

import de.riwagis.riwadatatable.validation.ValidationError;
import de.riwagis.util.exception.SystemException;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class ValidationSystemException
extends SystemException {
    private final ValidationError[] validationErrors;

    public ValidationSystemException(ValidationError ... validationErrors) {
        super(ValidationSystemException.getValidationErrorMessage(validationErrors));
        this.validationErrors = validationErrors;
    }

    public ValidationSystemException(Collection<ValidationError> validationErrors) {
        super(ValidationSystemException.getValidationErrorMessage(validationErrors.toArray(new ValidationError[validationErrors.size()])));
        this.validationErrors = validationErrors.toArray(new ValidationError[validationErrors.size()]);
    }

    public static String getValidationErrorMessage(ValidationError ... validationErrors) {
        StringBuilder sbMessage = new StringBuilder();
        for (ValidationError valError : validationErrors) {
            if (sbMessage.length() > 0 && StringUtils.isNotBlank((String)valError.getErrorMessage())) {
                sbMessage.append(", ");
            }
            sbMessage.append(StringUtils.trimToEmpty((String)valError.getErrorMessage()));
        }
        return sbMessage.toString();
    }

    public ValidationError[] getValidationErrors() {
        return this.validationErrors;
    }
}

