/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.validation;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.validation.ValidationErrorType;
import de.riwagis.riwadatatable.validation.ValidationSystemException;

public class ValidationError {
    private final TableColumn column;
    private final String errorMessage;
    private final ValidationErrorType type;
    private final Throwable linkedException;

    public ValidationError(String errorMessage) {
        this(null, errorMessage);
    }

    public ValidationError(TableColumn col, String errorMessage) {
        this(col, errorMessage, ValidationErrorType.UNKNOWN);
    }

    public ValidationError(TableColumn col, String errorMessage, ValidationErrorType type) {
        this(col, errorMessage, type, null);
    }

    public ValidationError(TableColumn col, String errorMessage, ValidationErrorType type, Throwable linkedException) {
        this.column = col;
        this.errorMessage = errorMessage;
        this.type = type == null ? ValidationErrorType.UNKNOWN : type;
        this.linkedException = linkedException;
    }

    public TableColumn getColumn() {
        return this.column;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ValidationErrorType getType() {
        return this.type;
    }

    public Throwable getLinkedException() {
        return this.linkedException;
    }

    public ValidationSystemException buildValidationSystemException4Class() {
        return new ValidationSystemException(this);
    }
}

