/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.validation;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.provider.ColumnProvider;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.validation.DataRowValidator;
import de.riwagis.riwadatatable.validation.ValidationError;
import de.riwagis.riwadatatable.validation.ValidationErrorType;
import java.util.ArrayList;
import java.util.Collection;

public class ColumnProviderDataRowValidator
implements DataRowValidator {
    private final ColumnProvider columnProvider;

    public ColumnProviderDataRowValidator(ColumnProvider columnProvider) {
        this.columnProvider = columnProvider;
    }

    @Override
    public Collection<ValidationError> validateDataRow(DataRow dataRow, DbTableOperationType operationType) {
        TableColumn col;
        String colName;
        int i;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (i = 0; i < dataRow.getColumnCount(); ++i) {
            colName = dataRow.getColumn(i).getColumnName();
            if (this.columnProvider.hasColumn(colName)) {
                col = this.columnProvider.getColumn(colName);
                ValidationError error = col.validateData(dataRow.getData(i));
                if (error == null) continue;
                errors.add(error);
                continue;
            }
            errors.add(new ValidationError(dataRow.getColumn(i), String.format("Datenfeld '%s' existiert nicht in Tabelle.", dataRow.getColumn(i).getColumnNameExternal()), ValidationErrorType.COLUMN_MISSING));
        }
        switch (operationType) {
            case UPDATE: 
            case INSERT: {
                for (i = 0; i < dataRow.getColumnCount(); ++i) {
                    colName = dataRow.getColumn(i).getColumnName();
                    col = this.columnProvider.getColumn(colName);
                    if (!col.isOnlySelect()) continue;
                    errors.add(new ValidationError(dataRow.getColumn(i), String.format("Datenfeld '%s' ist nur f\u00fcr Datenabfrage und nicht f\u00fcr \u00c4nderungen vorgesehen.", dataRow.getColumn(i).getColumnNameExternal()), ValidationErrorType.COLUMN_MISSING));
                }
                break;
            }
        }
        switch (operationType) {
            case DELETE: {
                if (!this.columnProvider.hasIDColumn() || dataRow.hasColumn(this.columnProvider.getIDColumn().getColumnName()) && dataRow.getData(this.columnProvider.getIDColumn().getColumnName()) != null) break;
                errors.add(new ValidationError(this.columnProvider.getIDColumn(), String.format("Zum L\u00f6schen eines Datensatzes muss ein Wert f\u00fcr den Prim\u00e4rschl\u00fcssel angegeben werden.", new Object[0]), ValidationErrorType.PRIMARYKEY_VALUE_MISSING));
                break;
            }
            case INSERT: {
                for (TableColumn col2 : this.columnProvider.getColumnsCollection()) {
                    if (col2.isOnlySelect() || dataRow.hasColumn(col2.getColumnName()) || col2.isNullable()) continue;
                    errors.add(new ValidationError(this.columnProvider.getIDColumn(), String.format("Datenfeld '%s' darf nicht leer sein.", col2.getColumnNameExternal()), ValidationErrorType.NULL_NOT_ALLOWED));
                }
                break;
            }
        }
        return errors;
    }
}

