/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.transaction;

import de.riwagis.riwadatatable.transaction.TransactionManager;
import java.util.concurrent.atomic.AtomicBoolean;

class TransactionWatchDog
extends Thread {
    private final long maxIdleTime;
    private final AtomicBoolean keepRunning = new AtomicBoolean(true);
    private final TransactionManager transactionManager;

    TransactionWatchDog(long maxIdleTime, TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.maxIdleTime = maxIdleTime;
        this.setDaemon(true);
        this.setName("RiwaDataTable - TransactionWatchDog");
    }

    public void shutdown() {
        this.keepRunning.set(false);
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        long watchIntervall = this.maxIdleTime / 3L;
        long lastWatch = 0L;
        while (this.keepRunning.get()) {
            try {
                Thread.sleep(Math.min(2000L, watchIntervall));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (lastWatch + watchIntervall > System.currentTimeMillis()) continue;
            this.transactionManager.closeOldUnusedConnections(this.maxIdleTime);
            lastWatch = System.currentTimeMillis();
        }
    }
}

