/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.transaction;

import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.transaction.TransactionManager;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;

public class TransactionConnectionManager
implements JDBCConnectionManager {
    private final TransactionManager transactionManager;
    private final JDBCConnectionInfo connInfo;
    private final int transactionKey;

    public TransactionConnectionManager(TransactionManager transactionManager, int transactionKey, JDBCConnectionInfo connInfo) {
        this.transactionManager = transactionManager;
        this.connInfo = connInfo;
        this.transactionKey = transactionKey;
    }

    @Override
    public JDBCConnectionInfo getConnectionInfo() {
        return this.connInfo;
    }

    @Override
    public Connection createConnection() throws SystemException {
        return this.transactionManager.checkOutConnection(this.transactionKey);
    }

    @Override
    public void closeConnection(Connection conn) throws SystemException {
        this.transactionManager.checkInConnection(this.transactionKey);
    }

    @Override
    public void close() {
    }
}

