/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.geotools;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.data.DataRowReader;
import de.riwagis.riwadatatable.table.geotools.FeatureDbTableImpl;
import de.riwagis.util.exception.SystemException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureReader4DataRowReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private final DataRowReader rowReader;
    private final SimpleFeatureType featureType;
    private final TableColumn idColumn;
    private final Collection<TableColumn> columns;
    private final boolean returnIdColumn;
    private final boolean fidWithLeadingTablename;

    public FeatureReader4DataRowReader(DataRowReader rowReader, FeatureDbTableImpl featureTable, boolean returnIdColumn) {
        this.rowReader = rowReader;
        this.idColumn = rowReader.hasIDColumn() ? rowReader.getIDColumn() : null;
        this.fidWithLeadingTablename = featureTable.isFidWithLeadingTablename();
        this.returnIdColumn = returnIdColumn;
        this.columns = rowReader.getColumnsCollection();
        if (returnIdColumn) {
            this.featureType = featureTable.getFeatureType(this.columns);
        } else {
            ArrayList<TableColumn> typeColumns = new ArrayList<TableColumn>(this.columns);
            typeColumns.remove(this.idColumn);
            this.featureType = featureTable.getFeatureType(typeColumns);
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    private String createFidString(String fidWithoutLeadingTablename) {
        if (this.fidWithLeadingTablename) {
            return this.featureType.getTypeName() + "." + fidWithoutLeadingTablename;
        }
        return fidWithoutLeadingTablename;
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        DataRow row = (DataRow)this.rowReader.next();
        Object[] rowData = row.getDataAsArray();
        String fid = this.idColumn != null ? this.createFidString(row.getDataAsString(this.idColumn.getColumnName())) : null;
        if (this.returnIdColumn || this.idColumn == null) {
            return SimpleFeatureBuilder.build((SimpleFeatureType)this.featureType, (Object[])rowData, (String)fid);
        }
        Object[] rowDataWithoutFid = new Object[rowData.length - 1];
        int rowDataCount = 0;
        int rowDataWithoutFidCount = 0;
        for (TableColumn column : this.columns) {
            if (column == this.idColumn) {
                ++rowDataCount;
                continue;
            }
            rowDataWithoutFid[rowDataWithoutFidCount] = rowData[rowDataCount];
            ++rowDataWithoutFidCount;
            ++rowDataCount;
        }
        return SimpleFeatureBuilder.build((SimpleFeatureType)this.featureType, (Object[])rowDataWithoutFid, (String)fid);
    }

    public boolean hasNext() throws IOException {
        return this.rowReader.hasNext();
    }

    public void close() throws IOException {
        try {
            this.rowReader.close();
        }
        catch (SystemException e) {
            throw new IOException(String.format("error closing feature reader for feature type '%s.%s': %s", this.featureType.getName().getNamespaceURI(), this.featureType.getName().getLocalPart(), e.getMessage()), e);
        }
    }
}

