/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.geotools;

import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwadatatable.columns.ColumnUtils;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.data.DataRowReader;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.DbTableImpl;
import de.riwagis.riwadatatable.table.TableDefinition;
import de.riwagis.riwadatatable.table.extension.DbTableExtender;
import de.riwagis.riwadatatable.table.geotools.ColumnFeatureTypeBuilder;
import de.riwagis.riwadatatable.table.geotools.DataRowReader4FeatureReader;
import de.riwagis.riwadatatable.table.geotools.FeatureDbTable;
import de.riwagis.riwadatatable.table.geotools.FeatureReader4DataRowReader;
import de.riwagis.riwadatatable.table.userinfo.DbTableUserInfo;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.geotools.data.FeatureReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureDbTableImpl
extends DbTableImpl
implements FeatureDbTable {
    private boolean fidWithLeadingTablename = false;

    public FeatureDbTableImpl(TableDefinition tblDef, JDBCConnectionManager connMngr, Collection<DbTableExtender> extenders, DbTableUserInfo userInfo) throws SystemException {
        super(tblDef, connMngr, extenders, userInfo);
    }

    @Override
    public boolean isFidWithLeadingTablename() {
        return this.fidWithLeadingTablename;
    }

    @Override
    public void setFidWithLeadingTablename(boolean fidWithLeadingTablename) {
        this.fidWithLeadingTablename = fidWithLeadingTablename;
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.getFeatureType(this.getColumnsCollection());
    }

    @Override
    public SimpleFeatureType getFeatureType(String ... columns) throws SystemException {
        return this.getFeatureType(this.getColumnsCollection(columns));
    }

    @Override
    public SimpleFeatureType getFeatureType(Collection<TableColumn> columns) {
        Collection<TableColumn> columnsUnique = ColumnUtils.makeUniqueColumns(columns);
        ColumnFeatureTypeBuilder cftb = new ColumnFeatureTypeBuilder(this.getTablename(), columnsUnique);
        return cftb.buildFeatureType();
    }

    @Override
    public DataRow convertFeature2DataRow(SimpleFeature feature2Convert, boolean returnIdColumn) {
        return FeatureDbTableImpl.feature2DataRow(this, feature2Convert, returnIdColumn);
    }

    public static DataRow feature2DataRow(DbTable tbl, SimpleFeature feature2Convert, boolean returnIdColumn) {
        String idColumnName;
        TableColumn idColumn;
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        ArrayList<Object> data = new ArrayList<Object>();
        SimpleFeatureType fType = feature2Convert.getFeatureType();
        if (tbl.hasIDColumn()) {
            idColumn = tbl.getIDColumn();
            idColumnName = idColumn.getColumnName();
        } else {
            idColumn = null;
            idColumnName = "";
        }
        for (int i = 0; i < feature2Convert.getAttributeCount(); ++i) {
            String columnName = fType.getDescriptor(i).getLocalName();
            if (!tbl.hasColumn(columnName)) {
                throw new IllegalArgumentException(String.format("Column '%s' of given feature does not exist in table '%s'", columnName, tbl.getTablename()));
            }
            if (idColumnName.equalsIgnoreCase(columnName)) continue;
            columns.add(tbl.getColumn(columnName));
            data.add(feature2Convert.getAttribute(i));
        }
        if (returnIdColumn && idColumn != null) {
            Object pkValue;
            try {
                pkValue = idColumn.parseObject(FeatureUtil.getFeatureIDWithoutTable((String)feature2Convert.getID()));
            }
            catch (SystemException se) {
                throw new IllegalArgumentException(String.format("Feature ID '%s' of given feature can not be parsed by column '%s' of table '%s'", feature2Convert.getID(), idColumn.getColumnName(), tbl.getTablename()));
            }
            columns.add(0, idColumn);
            data.add(0, pkValue);
        }
        return new DataRow(columns, data);
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(DataTableQuery query) throws SystemException {
        DataRowReader rowReader = this.getData(query, (Collection)this.getColumnNames());
        return new FeatureReader4DataRowReader(rowReader, this, true);
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Connection conn, DataTableQuery query) throws SystemException {
        DataRowReader rowReader = this.getData(conn, query, (Collection)this.getColumnNames());
        return new FeatureReader4DataRowReader(rowReader, this, true);
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(DataTableQuery query, String ... columnNames) throws SystemException {
        ArrayList<String> columnNamesCol = new ArrayList<String>(Arrays.asList(columnNames));
        boolean returnFidAsAttribute = !this.addFidColumnIfNotExists(columnNamesCol);
        DataRowReader rowReader = this.getData(query, columnNamesCol);
        return new FeatureReader4DataRowReader(rowReader, this, returnFidAsAttribute);
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Connection conn, DataTableQuery query, String ... columnNames) throws SystemException {
        ArrayList<String> columnNamesCol = new ArrayList<String>(Arrays.asList(columnNames));
        boolean returnFidAsAttribute = !this.addFidColumnIfNotExists(columnNamesCol);
        DataRowReader rowReader = this.getData(conn, query, columnNamesCol);
        return new FeatureReader4DataRowReader(rowReader, this, returnFidAsAttribute);
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(DataTableQuery query, Collection<String> columnNames) throws SystemException {
        ArrayList<String> columnNamesCol = new ArrayList<String>(columnNames);
        boolean returnFidAsAttribute = !this.addFidColumnIfNotExists(columnNamesCol);
        DataRowReader rowReader = this.getData(query, columnNamesCol);
        return new FeatureReader4DataRowReader(rowReader, this, returnFidAsAttribute);
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Connection conn, DataTableQuery query, Collection<String> columnNames) throws SystemException {
        ArrayList<String> columnNamesCol = new ArrayList<String>(columnNames);
        boolean returnFidAsAttribute = !this.addFidColumnIfNotExists(columnNamesCol);
        DataRowReader rowReader = this.getData(conn, query, columnNamesCol);
        return new FeatureReader4DataRowReader(rowReader, this, returnFidAsAttribute);
    }

    private boolean addFidColumnIfNotExists(Collection<String> columnNames) {
        if (!this.hasIDColumn()) {
            return false;
        }
        if (columnNames.contains(this.getIDColumn().getColumnName())) {
            return false;
        }
        columnNames.add(this.getIDColumn().getColumnName());
        return true;
    }

    private String retrieveLastInsertedIdAsString() {
        if (this.hasIDColumn()) {
            return this.getIDColumn().format(this.getIDLastInsert());
        }
        return null;
    }

    @Override
    public String insertFeature(SimpleFeature feature) throws SystemException {
        DataRow row = this.convertFeature2DataRow(feature, false);
        this.insertData(row);
        return this.retrieveLastInsertedIdAsString();
    }

    @Override
    public String insertFeature(Connection conn, SimpleFeature feature) throws SystemException {
        DataRow row = this.convertFeature2DataRow(feature, false);
        this.insertData(conn, row);
        return this.retrieveLastInsertedIdAsString();
    }

    @Override
    public int insertFeature(FeatureReader<SimpleFeatureType, SimpleFeature> featureReader) throws SystemException {
        DataRowReader4FeatureReader rowReader = new DataRowReader4FeatureReader(featureReader, this, false);
        return this.insertData(rowReader);
    }

    @Override
    public int insertFeature(Connection conn, FeatureReader<SimpleFeatureType, SimpleFeature> featureReader) throws SystemException {
        DataRowReader4FeatureReader rowReader = new DataRowReader4FeatureReader(featureReader, this, false);
        return this.insertData(conn, rowReader);
    }

    @Override
    public int updateFeature(SimpleFeature feature) throws SystemException {
        DataRow row = this.convertFeature2DataRow(feature, true);
        return this.updateData(row);
    }

    @Override
    public int updateFeature(Connection conn, SimpleFeature feature) throws SystemException {
        DataRow row = this.convertFeature2DataRow(feature, true);
        return this.updateData(conn, row);
    }

    @Override
    public int updateFeature(FeatureReader<SimpleFeatureType, SimpleFeature> featureReader) throws SystemException {
        DataRowReader4FeatureReader rowReader = new DataRowReader4FeatureReader(featureReader, this, true);
        return this.updateData(rowReader);
    }

    @Override
    public int updateFeature(Connection conn, FeatureReader<SimpleFeatureType, SimpleFeature> featureReader) throws SystemException {
        DataRowReader4FeatureReader rowReader = new DataRowReader4FeatureReader(featureReader, this, true);
        return this.updateData(conn, rowReader);
    }

    @Override
    public int deleteFeature(SimpleFeature feature) throws SystemException {
        DataRow row = this.convertFeature2DataRow(feature, true);
        return this.deleteData(row);
    }

    @Override
    public int deleteFeature(Connection conn, SimpleFeature feature) throws SystemException {
        DataRow row = this.convertFeature2DataRow(feature, true);
        return this.deleteData(conn, row);
    }

    @Override
    public int deleteFeature(FeatureReader<SimpleFeatureType, SimpleFeature> featureReader) throws SystemException {
        DataRowReader4FeatureReader rowReader = new DataRowReader4FeatureReader(featureReader, this, true);
        return this.deleteData(rowReader);
    }

    @Override
    public int deleteFeature(Connection conn, FeatureReader<SimpleFeatureType, SimpleFeature> featureReader) throws SystemException {
        DataRowReader4FeatureReader rowReader = new DataRowReader4FeatureReader(featureReader, this, true);
        return this.deleteData(conn, rowReader);
    }
}

