/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.geotools;

import de.riwagis.riwadatatable.columns.GeoColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.provider.ArrayBasedColumnProvider;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.data.DataRowReader;
import de.riwagis.riwadatatable.table.geotools.FeatureDbTable;
import de.riwagis.util.exception.SystemException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.geotools.data.FeatureReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRowReader4FeatureReader
implements DataRowReader {
    private static final Logger LOG = LoggerFactory.getLogger(DataRowReader4FeatureReader.class);
    private final FeatureReader<SimpleFeatureType, SimpleFeature> featureReader;
    private final FeatureDbTable featureTable;
    private final ArrayBasedColumnProvider columnProvider;
    private final boolean returnIdColumn;

    public DataRowReader4FeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> featureReader, FeatureDbTable featureTable, boolean returnIdColumn) throws SystemException {
        this.featureReader = featureReader;
        this.featureTable = featureTable;
        this.returnIdColumn = returnIdColumn;
        List descriptors = ((SimpleFeatureType)featureReader.getFeatureType()).getAttributeDescriptors();
        String idColumnName = featureTable.hasIDColumn() ? featureTable.getIDColumn().getColumnName() : "";
        ArrayList<String> columnNames = new ArrayList<String>();
        for (AttributeDescriptor descriptor : descriptors) {
            if (!featureTable.hasColumn(descriptor.getLocalName())) {
                throw new SystemException(String.format("Error reading features from FeatureReader. Column '%s' does not exist in table '%s.%s'", descriptor.getLocalName(), featureTable.getConnectionInfo().getScheme(), featureTable.getTablename()));
            }
            String columnName = descriptor.getLocalName().toLowerCase();
            if (columnName.equalsIgnoreCase(idColumnName)) continue;
            columnNames.add(columnName);
        }
        if (this.returnIdColumn && StringUtils.isNotBlank((String)idColumnName)) {
            columnNames.add(0, idColumnName.toLowerCase());
        }
        TableColumn[] columns = featureTable.getColumnsCollection(columnNames).toArray(new TableColumn[columnNames.size()]);
        this.columnProvider = new ArrayBasedColumnProvider(columns);
    }

    @Override
    public void closeQuietly() {
        try {
            this.featureReader.close();
        }
        catch (IOException eatit) {
            LOG.debug(String.format("ignoring error on closing featureReader on table '%s.%s': %s", this.featureTable.getConnectionInfo().getScheme(), this.featureTable.getTablename(), eatit.getMessage()));
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.featureReader.hasNext();
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format("Error reading features from FeatureReader for table '%s.%s'", this.featureTable.getConnectionInfo().getScheme(), this.featureTable.getTablename()), ioe);
        }
    }

    @Override
    public DataRow next() {
        try {
            SimpleFeature feature = (SimpleFeature)this.featureReader.next();
            return this.featureTable.convertFeature2DataRow(feature, this.returnIdColumn);
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format("Error reading features from FeatureReader for table '%s.%s'", this.featureTable.getConnectionInfo().getScheme(), this.featureTable.getTablename()), ioe);
        }
    }

    @Override
    public void close() throws SystemException {
        try {
            this.featureReader.close();
        }
        catch (IOException ioex) {
            throw new SystemException(String.format("unable to close featurereader on table '%s.%s': %s", this.featureTable.getConnectionInfo().getScheme(), this.featureTable.getTablename(), ioex.getMessage()), (Throwable)ioex);
        }
    }

    @Override
    public boolean hasColumn(String columnName) {
        return this.columnProvider.hasColumn(columnName);
    }

    @Override
    public TableColumn getColumn(String columnName) throws IllegalArgumentException {
        return this.columnProvider.getColumn(columnName);
    }

    @Override
    public Collection<TableColumn> getColumnsCollection() {
        return this.columnProvider.getColumnsCollection();
    }

    @Override
    public Collection<TableColumn> getColumnsCollection(Collection<String> columnNames) {
        return this.columnProvider.getColumnsCollection(columnNames);
    }

    @Override
    public Collection<TableColumn> getColumnsCollection(String ... columnNames) {
        return this.columnProvider.getColumnsCollection(columnNames);
    }

    @Override
    public Collection<String> getColumnNames() {
        return this.columnProvider.getColumnNames();
    }

    @Override
    public Collection<String> getColumnNames(Collection<TableColumn> columns) {
        return this.columnProvider.getColumnNames(columns);
    }

    @Override
    public Collection<String> getColumnNames(TableColumn ... columns) {
        return this.columnProvider.getColumnNames(columns);
    }

    @Override
    public boolean hasIDColumn() {
        return this.columnProvider.hasIDColumn();
    }

    @Override
    public TableColumn getIDColumn() throws IndexOutOfBoundsException {
        return this.columnProvider.getIDColumn();
    }

    @Override
    public GeoColumn getDefaultGeoColumn() throws IndexOutOfBoundsException {
        return this.columnProvider.getDefaultGeoColumn();
    }

    @Override
    public boolean hasGeoColumn() {
        return this.columnProvider.hasGeoColumn();
    }

    @Override
    public int getColumnCount() {
        return this.columnProvider.getColumnCount();
    }

    @Override
    public int getSqlType(String columnName) {
        return this.columnProvider.getSqlType(columnName);
    }

    @Override
    public boolean hasColumn(String columnName, int[] types) {
        return this.columnProvider.hasColumn(columnName, types);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

