/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.geotools;

import de.riwagis.riwadatatable.columns.TableColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeatureType;

public class ColumnFeatureTypeBuilder {
    private final Collection<TableColumn> columns = new ArrayList<TableColumn>();
    private final String typeName;

    public ColumnFeatureTypeBuilder(String typeName, TableColumn ... columns) {
        this(typeName, Arrays.asList(columns));
    }

    public ColumnFeatureTypeBuilder(String typeName, Collection<TableColumn> columns) {
        this.typeName = typeName;
        this.columns.addAll(columns);
    }

    public SimpleFeatureType buildFeatureType() {
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName(this.typeName);
        AttributeTypeBuilder attBuilder = new AttributeTypeBuilder();
        for (TableColumn col : this.columns) {
            ftBuilder.add(col.buildDescriptor(attBuilder));
        }
        return ftBuilder.buildFeatureType();
    }
}

