/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.restrictions;

import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderPriority;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtender;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableOperationInfo;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitTextLengthExtender
extends DbTableExtenderAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(LimitTextLengthExtender.class);

    public LimitTextLengthExtender(DbTableExtenderPriority priority) {
        super(priority);
    }

    @Override
    public DbTableOperationExtender createOperationExtender(DbTableOperationType type, Connection conn) throws SystemException {
        if (type == DbTableOperationType.INSERT || type == DbTableOperationType.UPDATE) {
            return new DbTableOperationExtenderAdapter(){

                @Override
                public DataRow adjustDataRow4Operation(DbTableOperationInfo operationInfo, DataRow row) throws SystemException {
                    for (TableColumn field : row.getColumnsCollection()) {
                        String columnName = field.getColumnName();
                        Object fieldValue = row.getData(columnName);
                        if (field.getType() != ColumnTypes.CT_TEXT_COLUMN || !(fieldValue instanceof String)) continue;
                        String oldVal = ObjectUtils.toString((Object)fieldValue);
                        int maxColumnSize = field.getColumnSize();
                        if (maxColumnSize < 0 || oldVal.length() <= maxColumnSize) continue;
                        String newVal = oldVal.substring(0, maxColumnSize);
                        row.setData(columnName, (Object)newVal);
                        LOG.warn(String.format("truncated field '%s.%s' value '%s' to '%s' (new length: %d)", field.getTableName(), columnName, oldVal, newVal, maxColumnSize));
                    }
                    return row;
                }
            };
        }
        return super.createOperationExtender(type, conn);
    }
}

