/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.presetvalues;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableOperationInfo;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.extension.presetvalues.DbTablePresetValue;
import de.riwagis.riwadatatable.table.extension.presetvalues.DbTablePresetValuesExtender;
import de.riwagis.util.exception.SystemException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTablePresetValuesOperationExtender
extends DbTableOperationExtenderAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DbTablePresetValuesOperationExtender.class);
    private final DbTablePresetValuesExtender extender;
    private final List<DbTablePresetValue> opPresetValues = new ArrayList<DbTablePresetValue>();
    private static final EnumSet<DbTableOperationType> VALID_OPERATION_TYPE = EnumSet.of(DbTableOperationType.DELETE, DbTableOperationType.INSERT, DbTableOperationType.UPDATE);

    public DbTablePresetValuesOperationExtender(DbTablePresetValuesExtender extender) {
        if (extender == null) {
            throw new NullPointerException("extender must not be null");
        }
        this.extender = extender;
    }

    @Override
    public Collection<String> extendColumns4Operation(DbTableOperationInfo operationInfo, Collection<TableColumn> columns) throws SystemException {
        ArrayList<String> colNames2Add = new ArrayList<String>(super.extendColumns4Operation(operationInfo, columns));
        this.opPresetValues.clear();
        if (VALID_OPERATION_TYPE.contains((Object)operationInfo.getOperationType())) {
            Collection<DbTablePresetValue> presetValues = this.extender.getPresetValues(operationInfo.getOperationType());
            for (DbTablePresetValue presetVal : presetValues) {
                boolean columnFound = false;
                for (TableColumn col : columns) {
                    if (!presetVal.getColumnName().equalsIgnoreCase(col.getColumnName())) continue;
                    columnFound = true;
                }
                this.opPresetValues.add(presetVal);
                if (columnFound) continue;
                colNames2Add.add(presetVal.getColumnName());
            }
        }
        return colNames2Add;
    }

    @Override
    public DataRow adjustDataRow4Operation(DbTableOperationInfo operationInfo, DataRow row2adjust) throws SystemException {
        if (row2adjust == null) {
            throw new NullPointerException(String.format("DataRow is null. Schema: %s ,Tablename: %s", operationInfo.getDbTable().getConnectionInfo().getScheme(), operationInfo.getDbTable().getTablename()));
        }
        if (VALID_OPERATION_TYPE.contains((Object)operationInfo.getOperationType())) {
            for (DbTablePresetValue presetVal : this.opPresetValues) {
                if ((row2adjust.getData(presetVal.getColumnName()) != null || !this.extender.isOverwriteNullValues()) && !this.extender.isOverwrite()) continue;
                row2adjust.setData(presetVal.getColumnName(), presetVal.getPresetValueData().getPresetData());
            }
        }
        return row2adjust;
    }
}

