/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.presetvalues;

import de.riwagis.riwadatatable.columns.AbstractDateColumn;
import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.DateColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderPriority;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtender;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.extension.presetvalues.DbTableDefaultPresetColumns;
import de.riwagis.riwadatatable.table.extension.presetvalues.DbTablePresetValue;
import de.riwagis.riwadatatable.table.extension.presetvalues.DbTablePresetValuesOperationExtender;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DbTablePresetValuesExtender
extends DbTableExtenderAdapter {
    private final List<DbTablePresetValue> presetValues = new ArrayList<DbTablePresetValue>();
    private boolean overwrite = false;
    private boolean overwriteNullValues = true;

    public DbTablePresetValuesExtender(DbTable dbTable) {
        super(DbTableExtenderPriority.FIRST);
        this.initUserInfoPresetValues(dbTable);
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isOverwriteNullValues() {
        return this.overwriteNullValues;
    }

    public void setOverwriteNullValues(boolean overwriteNullValuesForDateColumns) {
        this.overwriteNullValues = overwriteNullValuesForDateColumns;
    }

    public final void initUserInfoPresetValues(DbTable dbTable) {
        for (DbTableDefaultPresetColumns defaultPresetColumn : DbTableDefaultPresetColumns.values()) {
            DbTablePresetValue pVal2Remove = this.getPresetValue4ColumnName(defaultPresetColumn.getColumnName());
            if (pVal2Remove == null) continue;
            this.presetValues.remove(pVal2Remove);
        }
        Collection<DbTablePresetValue> userInfoPresetValues = DbTablePresetValue.presetValues4UserInfo(dbTable.getUserInfo());
        for (DbTablePresetValue pVal : userInfoPresetValues) {
            if (!dbTable.hasColumn(pVal.getColumnName())) continue;
            this.presetValues.add(pVal);
        }
    }

    @Override
    public void afterInitialisation(DbTable dbTable) throws SystemException {
        super.afterInitialisation(dbTable);
        for (DbTableDefaultPresetColumns currColumn : DbTableDefaultPresetColumns.values()) {
            TableColumn systemFilledColumn;
            if (!dbTable.hasColumn(currColumn.getColumnName()) || (systemFilledColumn = dbTable.getColumn(currColumn.getColumnName())).getType() != ColumnTypes.CT_DATE_COLUMN || !(systemFilledColumn instanceof DateColumn)) continue;
            ((AbstractDateColumn)systemFilledColumn).setDateTime(true);
        }
    }

    public DbTablePresetValue getPresetValue4ColumnName(String columnName) {
        for (DbTablePresetValue pVal : this.presetValues) {
            if (!pVal.getColumnName().equalsIgnoreCase(columnName)) continue;
            return pVal;
        }
        return null;
    }

    public Collection<DbTablePresetValue> getPresetValues() {
        return Collections.unmodifiableCollection(this.presetValues);
    }

    public Collection<DbTablePresetValue> getPresetValues(DbTableOperationType operationType) {
        ArrayList<DbTablePresetValue> presetValues2Return = new ArrayList<DbTablePresetValue>();
        for (DbTablePresetValue presetValue : this.presetValues) {
            if (presetValue.getTrigger() != operationType) continue;
            presetValues2Return.add(presetValue);
        }
        return presetValues2Return;
    }

    public boolean removePresetValue(DbTablePresetValue presetValue) {
        return this.presetValues.remove(presetValue);
    }

    public void addPresetValue(DbTablePresetValue presetValue) {
        this.presetValues.add(presetValue);
    }

    @Override
    public DbTableOperationExtender createOperationExtender(DbTableOperationType type, Connection conn) throws SystemException {
        if (type == DbTableOperationType.SELECT) {
            return null;
        }
        return new DbTablePresetValuesOperationExtender(this);
    }
}

