/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.presetvalues;

import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.extension.presetvalues.DbTableDefaultPresetColumns;
import de.riwagis.riwadatatable.table.extension.presetvalues.DbTablePresetValueData;
import de.riwagis.riwadatatable.table.userinfo.DbTableUserInfo;
import java.util.ArrayList;
import java.util.Collection;

public class DbTablePresetValue {
    private final DbTableOperationType trigger;
    private final String columnName;
    private final DbTablePresetValueData presetValueData;
    private final DbTableDefaultPresetColumns defaultPresetColumn;

    public DbTablePresetValue(String columnName, DbTablePresetValueData presetValueData, DbTableOperationType trigger) {
        this(columnName, presetValueData, trigger, null);
    }

    public DbTablePresetValue(DbTablePresetValueData presetValueData, DbTableDefaultPresetColumns defaultPresetColumn) {
        this(defaultPresetColumn.getColumnName(), presetValueData, defaultPresetColumn.getTrigger(), defaultPresetColumn);
    }

    public DbTablePresetValue(String columnName, DbTablePresetValueData presetValueData, DbTableDefaultPresetColumns defaultPresetColumn) {
        this(columnName, presetValueData, defaultPresetColumn.getTrigger(), defaultPresetColumn);
    }

    private DbTablePresetValue(String columnName, DbTablePresetValueData presetValueData, DbTableOperationType trigger, DbTableDefaultPresetColumns defaultPresetColumn) {
        this.trigger = trigger;
        this.columnName = columnName;
        this.presetValueData = presetValueData;
        this.defaultPresetColumn = defaultPresetColumn;
    }

    public static Collection<DbTablePresetValue> presetValues4UserInfo(DbTableUserInfo userInfo) {
        ArrayList<DbTablePresetValue> tablePresetValues = new ArrayList<DbTablePresetValue>();
        tablePresetValues.add(new DbTablePresetValue(DbTablePresetValueData.getCurrentDateInstance(), DbTableDefaultPresetColumns.DATE_CREATED));
        tablePresetValues.add(new DbTablePresetValue(DbTablePresetValueData.getCurrentDateInstance(), DbTableDefaultPresetColumns.DATE_MODIFIED));
        tablePresetValues.add(new DbTablePresetValue(DbTablePresetValueData.getCurrentDateInstance(), DbTableDefaultPresetColumns.DATE_DELETED));
        tablePresetValues.add(new DbTablePresetValue(DbTablePresetValueData.getNewUUID(), DbTableDefaultPresetColumns.UUID));
        if (userInfo != null) {
            tablePresetValues.add(new DbTablePresetValue(DbTablePresetValueData.getObjectInstance(userInfo.getUserOrganisationID()), DbTableDefaultPresetColumns.ADMINID_CREATED));
            tablePresetValues.add(new DbTablePresetValue(DbTablePresetValueData.getObjectInstance(userInfo.getUserOrganisationID()), DbTableDefaultPresetColumns.ADMINID_MODIFIED));
            tablePresetValues.add(new DbTablePresetValue(DbTablePresetValueData.getObjectInstance(userInfo.getUserOrganisationID()), DbTableDefaultPresetColumns.ADMINID_DELETED));
            tablePresetValues.add(new DbTablePresetValue(DbTablePresetValueData.getObjectInstance(userInfo.getUserID()), DbTableDefaultPresetColumns.USERID_CREATED));
            tablePresetValues.add(new DbTablePresetValue(DbTablePresetValueData.getObjectInstance(userInfo.getUserID()), DbTableDefaultPresetColumns.USERID_MODIFIED));
            tablePresetValues.add(new DbTablePresetValue(DbTablePresetValueData.getObjectInstance(userInfo.getUserID()), DbTableDefaultPresetColumns.USERID_DELETED));
            tablePresetValues.add(new DbTablePresetValue(DbTablePresetValueData.getObjectInstance(userInfo.getUserName()), DbTableDefaultPresetColumns.USER_CREATED));
            tablePresetValues.add(new DbTablePresetValue(DbTablePresetValueData.getObjectInstance(userInfo.getUserName()), DbTableDefaultPresetColumns.USER_MODIFIED));
            tablePresetValues.add(new DbTablePresetValue(DbTablePresetValueData.getObjectInstance(userInfo.getUserName()), DbTableDefaultPresetColumns.USER_DELETED));
        }
        return tablePresetValues;
    }

    public DbTableOperationType getTrigger() {
        return this.trigger;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public DbTableDefaultPresetColumns getDefaultColumn() {
        return this.defaultPresetColumn;
    }

    public DbTablePresetValueData getPresetValueData() {
        return this.presetValueData;
    }
}

