/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.presetvalues;

import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import org.apache.commons.lang.StringUtils;

public enum DbTableDefaultPresetColumns {
    ADMINID_CREATED("adminid_created", DbTableOperationType.INSERT),
    USERID_CREATED("userid_created", DbTableOperationType.INSERT),
    USER_CREATED("user_created", DbTableOperationType.INSERT),
    DATE_CREATED("date_created", DbTableOperationType.INSERT),
    ADMINID_MODIFIED("adminid_modified", DbTableOperationType.UPDATE),
    DATE_MODIFIED("date_modified", DbTableOperationType.UPDATE),
    USERID_MODIFIED("userid_modified", DbTableOperationType.UPDATE),
    USER_MODIFIED("user_modified", DbTableOperationType.UPDATE),
    ADMINID_DELETED("adminid_deleted", DbTableOperationType.DELETE),
    DATE_DELETED("date_deleted", DbTableOperationType.DELETE),
    USERID_DELETED("userid_deleted", DbTableOperationType.DELETE),
    USER_DELETED("user_deleted", DbTableOperationType.DELETE),
    UUID("riwa_uuid", DbTableOperationType.INSERT);

    private final String columnName;
    private final DbTableOperationType trigger;

    private DbTableDefaultPresetColumns(String columnName, DbTableOperationType trigger) {
        this.columnName = columnName;
        this.trigger = trigger;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public DbTableOperationType getTrigger() {
        return this.trigger;
    }

    public static DbTableDefaultPresetColumns getByName(String columnName) {
        String columnNameTrimmed = StringUtils.trimToEmpty((String)columnName);
        if (StringUtils.isNotBlank((String)columnNameTrimmed)) {
            for (DbTableDefaultPresetColumns currColumn : DbTableDefaultPresetColumns.values()) {
                if (!StringUtils.equalsIgnoreCase((String)columnNameTrimmed, (String)currColumn.getColumnName())) continue;
                return currColumn;
            }
        }
        return null;
    }

    public static boolean isDefaultPresetColumn(String columnName) {
        return DbTableDefaultPresetColumns.getByName(columnName) != null;
    }
}

