/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.logging.utils;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ColumnInfo {
    public static final String DEFAULT_DELIMITER = ";";
    private final String delimiter;
    private final Map<String, Object> columnValues;

    public ColumnInfo() {
        this(DEFAULT_DELIMITER);
    }

    public ColumnInfo(String delimiter) {
        this.delimiter = delimiter;
        this.columnValues = new LinkedHashMap<String, Object>();
    }

    public void addColumnValue(String columnName, Object value) {
        this.columnValues.put(columnName, value);
    }

    public Map<String, Object> getColumnInfos() {
        return this.columnValues;
    }

    public static String toPrettyString(ColumnInfo colInfo) {
        return ColumnInfo.toPrettyString(Arrays.asList(colInfo));
    }

    public static String toPrettyString(List<ColumnInfo> colInfos) {
        if (CollectionUtils.isEmpty(colInfos)) {
            return null;
        }
        return colInfos.stream().map(colInfo -> colInfo.toString()).collect(Collectors.joining(System.lineSeparator()));
    }

    public String toString() {
        if (this.columnValues.isEmpty()) {
            return "";
        }
        return this.columnValues.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + String.valueOf(entry.getValue())).collect(Collectors.joining(String.format("%s%s", this.delimiter, DEFAULT_DELIMITER.equals(this.delimiter) ? " " : "")));
    }
}

