/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.logging.query;

import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.extension.logging.query.LogEntry;
import de.riwagis.riwadatatable.table.extension.logging.query.LogEntryFilter;
import de.riwagis.util.StringSupport;
import de.riwagis.util.jdbc.JDBCSupport;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class LogEntryReader {
    public int readEntryCount(Connection conn, LogEntryFilter f) throws SQLException {
        ArrayList<Object> o = new ArrayList<Object>();
        String sqlCount = String.format("SELECT COUNT(id)   FROM dbparser_log   %s", LogEntryReader.buildStatementWhere(f, o));
        try (PreparedStatement pstmt = conn.prepareStatement(sqlCount);){
            this.fillParameters(pstmt, o);
            try (ResultSet rs = pstmt.executeQuery();){
                if (rs.next()) {
                    int n = rs.getInt(1);
                    return n;
                }
                throw new SQLException("illegal query");
            }
        }
    }

    public void fillParameters(PreparedStatement pstmt, List<Object> parameters) throws SQLException {
        for (int i = 0; i < parameters.size(); ++i) {
            pstmt.setObject(i + 1, this.adjustParameter(parameters.get(i)));
        }
    }

    public List<LogEntry> readEntry(Connection conn, LogEntryFilter f) throws SQLException {
        ArrayList<LogEntry> les = new ArrayList<LogEntry>();
        ArrayList<Object> o = new ArrayList<Object>();
        String sql = String.format("SELECT id, exec_date, exec_type, username,        exec_sql1, exec_sql2, exec_sql3, exec_sql4,        tablename, affected_pk, additional_cols, exec_sql2_ori   FROM dbparser_log   %s   ORDER BY exec_date DESC", LogEntryReader.buildStatementWhere(f, o));
        try (PreparedStatement pstmt = conn.prepareStatement(sql);){
            this.fillParameters(pstmt, o);
            try (ResultSet rs = pstmt.executeQuery();){
                while (rs.next()) {
                    Integer id = rs.getInt("id");
                    Date execDate = LogEntryReader.convertTimestamp(rs.getTimestamp("exec_date"));
                    DbTableOperationType type = DbTableOperationType.byNumValue(rs.getInt("exec_type"));
                    LinkedHashSet<String> joinedExecSQLParts = new LinkedHashSet<String>();
                    LogEntryReader.addSQLPart(joinedExecSQLParts, rs.getString("exec_sql1"));
                    LogEntryReader.addSQLPart(joinedExecSQLParts, rs.getString("exec_sql2"));
                    LogEntryReader.addSQLPart(joinedExecSQLParts, rs.getString("exec_sql3"));
                    LogEntryReader.addSQLPart(joinedExecSQLParts, rs.getString("exec_sql4"));
                    LogEntry currEntry = new LogEntry(id, execDate, type, rs.getString("username"), StringUtils.join(joinedExecSQLParts, (String)", "), rs.getString("tablename"), rs.getString("exec_sql2_ori"));
                    currEntry.setAffectedPk(this.parseAffectedPk(rs.getString("affected_pk")));
                    currEntry.setAdditionalCols(rs.getString("additional_cols"));
                    les.add(currEntry);
                }
            }
        }
        return les;
    }

    public static Date convertTimestamp(Timestamp ts) {
        return ts == null ? null : new Date(ts.getTime());
    }

    public static String buildStatementWhere(LogEntryFilter f, List<Object> parameters) {
        LinkedHashSet<String> pkQueryParts = new LinkedHashSet<String>();
        for (String currPK : f.getAffectedPKs()) {
            pkQueryParts.add(String.format("(affected_pk LIKE %s OR affected_pk LIKE %s OR affected_pk LIKE %s OR affected_pk LIKE %s)", StringSupport.quoteString((String)currPK, (String)"'", (String)"''"), StringSupport.quoteString((String)(currPK + ",%"), (String)"'", (String)"''"), StringSupport.quoteString((String)("%," + currPK), (String)"'", (String)"''"), StringSupport.quoteString((String)("%," + currPK + ",%"), (String)"'", (String)"''")));
        }
        ArrayList<String> andParts = new ArrayList<String>();
        if (!f.getTablenames().isEmpty()) {
            andParts.add(JDBCSupport.buildInList((String)"tablename", f.getTablenames(), (String)"'"));
        }
        if (!pkQueryParts.isEmpty()) {
            andParts.add(String.format("(%s)", StringUtils.join(pkQueryParts, (String)" OR ")));
        }
        if (f.getFromDate() != null) {
            andParts.add("exec_date>=?");
            parameters.add(f.getFromDate());
        }
        if (f.getToDate() != null) {
            andParts.add("exec_date<?");
            parameters.add(DateUtils.addDays((Date)f.getToDate(), (int)1));
        }
        LinkedHashSet<CallSite> typeQueryParts = new LinkedHashSet<CallSite>();
        for (DbTableOperationType operationType : f.getOperationTypes()) {
            typeQueryParts.add((CallSite)((Object)("exec_type=" + operationType.getNumericValue())));
        }
        if (!typeQueryParts.isEmpty()) {
            andParts.add(String.format("(%s)", StringUtils.join(typeQueryParts, (String)" OR ")));
        }
        String wherePart = andParts.isEmpty() ? "" : " WHERE " + StringUtils.join(andParts, (String)" AND ");
        return StringUtils.normalizeSpace((String)wherePart);
    }

    public static void addSQLPart(Collection<String> joinedExecSQLParts, String string) {
        if (StringUtils.isNotBlank((CharSequence)string)) {
            joinedExecSQLParts.add(StringUtils.trimToEmpty((String)string));
        }
    }

    private Collection<String> parseAffectedPk(String affectedPkString) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)affectedPkString)) {
            for (String currentPK : affectedPkString.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)currentPK)) continue;
                res.add(StringUtils.trim((String)currentPK));
            }
        }
        return res;
    }

    private Object adjustParameter(Object parameter) {
        if (parameter != null && parameter instanceof Date) {
            return new java.sql.Date(((Date)parameter).getTime());
        }
        return parameter;
    }
}

