/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.logging.query;

import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class LogEntryFilter {
    private static final int DATE_RESOLUTION = 5;
    private final Collection<String> tablenames = new LinkedHashSet<String>();
    private final Collection<String> affectedPKs = new LinkedHashSet<String>();
    private Date fromDate;
    private Date toDate;
    private final Collection<DbTableOperationType> operationTypes = new LinkedHashSet<DbTableOperationType>();

    public final void addTablename(String tablename) {
        if (StringUtils.isNotBlank((CharSequence)tablename)) {
            this.tablenames.add(tablename);
        }
    }

    public final void addAffectedPK(String affectedPK) {
        if (StringUtils.isNotBlank((CharSequence)affectedPK)) {
            this.affectedPKs.add(affectedPK);
        }
    }

    public Collection<String> getAffectedPKs() {
        return Collections.unmodifiableCollection(this.affectedPKs);
    }

    public Collection<String> getTablenames() {
        return Collections.unmodifiableCollection(this.tablenames);
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = LogEntryFilter.copyDate(fromDate);
    }

    public Date getFromDate() {
        return LogEntryFilter.copyDate(this.fromDate);
    }

    public void setToDate(Date toDate) {
        this.toDate = LogEntryFilter.copyDate(toDate);
    }

    public Date getToDate() {
        return LogEntryFilter.copyDate(this.toDate);
    }

    public void addOperationType(DbTableOperationType operationType) {
        if (operationType != null) {
            this.operationTypes.add(operationType);
        }
    }

    public Collection<DbTableOperationType> getOperationTypes() {
        return Collections.unmodifiableCollection(this.operationTypes);
    }

    private static Date copyDate(Date originalDate) {
        return originalDate != null ? DateUtils.truncate((Date)originalDate, (int)5) : null;
    }
}

