/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.logging.query;

import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;

public class LogEntry {
    private final Integer id;
    private final Date execDate;
    private final DbTableOperationType execType;
    private final String username;
    private final String execSQL1;
    private final String tablename;
    private final Collection<String> affectedPk = new LinkedHashSet<String>();
    private final String execSQL2;
    private String additionalCols;

    public LogEntry(Integer id, Date execDate, DbTableOperationType execType, String username, String execSQL1, String tablename, String execSQL2) {
        this.id = id;
        this.execDate = execDate == null ? null : new Date(execDate.getTime());
        this.execType = execType;
        this.username = username;
        this.execSQL1 = execSQL1;
        this.tablename = tablename;
        this.execSQL2 = execSQL2;
    }

    public void setAffectedPk(Collection<String> affectedPk) {
        this.affectedPk.clear();
        if (affectedPk != null) {
            this.affectedPk.addAll(affectedPk);
        }
    }

    public Collection<String> getAffectedPk() {
        return Collections.unmodifiableCollection(this.affectedPk);
    }

    public Date getExecDate() {
        return this.execDate == null ? null : new Date(this.execDate.getTime());
    }

    public Integer getId() {
        return this.id;
    }

    public DbTableOperationType getExecType() {
        return this.execType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getExecSQL1() {
        return this.execSQL1;
    }

    public String getTablename() {
        return this.tablename;
    }

    public String getExecSQL2() {
        return this.execSQL2;
    }

    public String getAdditionalCols() {
        return this.additionalCols;
    }

    public void setAdditionalCols(String additionalCols) {
        this.additionalCols = additionalCols;
    }
}

