/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.logging.query;

import de.riwagis.riwadatatable.table.extension.logging.query.LogConfigEntry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConfigReader {
    private static final Logger LOG = LoggerFactory.getLogger(LogConfigReader.class);

    public static Collection<LogConfigEntry> readAll(Connection conn) throws SQLException {
        LinkedHashSet<LogConfigEntry> res = new LinkedHashSet<LogConfigEntry>();
        try (PreparedStatement stmt = conn.prepareStatement("SELECT tablename, cols_to_log, id FROM dbparser_log_config");
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                String tablename = rs.getString("tablename");
                int id = rs.getInt("id");
                Integer modificationLogLevel = LogConfigReader.readModificationLevel(conn, id);
                LogConfigEntry lce = new LogConfigEntry(id, tablename, modificationLogLevel);
                lce.setColsToLog(LogConfigEntry.parseColsToLog(rs.getString("cols_to_log")));
                res.add(lce);
            }
        }
        return res;
    }

    public static Integer readModificationLevel(Connection conn, int id) {
        Integer modificationLogLevel = null;
        try (PreparedStatement psModificationLogLevel = conn.prepareStatement("SELECT modif_log_level FROM dbparser_log_config WHERE id=?");){
            psModificationLogLevel.setInt(1, id);
            try (ResultSet rsModificationLogLevel = psModificationLogLevel.executeQuery();){
                if (rsModificationLogLevel.next()) {
                    modificationLogLevel = rsModificationLogLevel.getInt("modif_log_level");
                }
            }
        }
        catch (Exception eatit) {
            LOG.trace(String.format("modif_log_level column does not exist/is not readable: %s", eatit.getMessage()), (Throwable)eatit);
        }
        return modificationLogLevel;
    }

    public static LogConfigEntry read(Connection conn, String tablename) throws SQLException {
        Collection<LogConfigEntry> entries = LogConfigReader.readAll(conn);
        for (LogConfigEntry currEntry : entries) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)tablename, (CharSequence)currEntry.getTablename())) continue;
            return currEntry;
        }
        return null;
    }
}

