/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.logging.query;

import de.riwagis.riwadatatable.table.extension.logging.utils.ColumnAliasBean;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConfigEntry {
    private static final Logger log = LoggerFactory.getLogger(LogConfigEntry.class);
    public static final String COLUMN_DELIMITER = "\\s*[,|;|\\|]\\s*";
    public static final Pattern COLUMN_WITH_ALIAS = Pattern.compile("^\\s*(\\S+)\\s*<(.*\\S+.*)>\\s*$");
    final Integer id;
    final String tablename;
    final Integer modificationLogLevel;
    final Collection<ColumnAliasBean> columnsToLog = new LinkedHashSet<ColumnAliasBean>();

    public LogConfigEntry(Integer id, String tablename, Integer modificationLogLevel) {
        this.id = id;
        this.tablename = tablename;
        this.modificationLogLevel = modificationLogLevel;
    }

    public void setColsToLog(Collection<ColumnAliasBean> colsToLog) {
        this.columnsToLog.clear();
        for (ColumnAliasBean currColumn : colsToLog) {
            if (currColumn == null) continue;
            this.columnsToLog.add(currColumn);
        }
    }

    public void setColsToLog(String colsToLog) {
        this.setColsToLog(LogConfigEntry.parseColsToLog(colsToLog));
    }

    public Collection<ColumnAliasBean> getColumnsToLog() {
        return Collections.unmodifiableCollection(this.columnsToLog);
    }

    public static final Collection<ColumnAliasBean> parseColsToLog(String colsToLog) {
        LinkedHashSet<ColumnAliasBean> res = new LinkedHashSet<ColumnAliasBean>();
        if (StringUtils.isNotBlank((CharSequence)colsToLog)) {
            String[] splittedCols;
            for (String currColumn : splittedCols = StringUtils.trimToEmpty((String)colsToLog).split(COLUMN_DELIMITER)) {
                String columnAlias;
                String columnName;
                if (!StringUtils.isNotBlank((CharSequence)currColumn)) continue;
                Matcher colAliasMatcher = COLUMN_WITH_ALIAS.matcher(currColumn);
                if (colAliasMatcher.find()) {
                    columnName = StringUtils.trimToEmpty((String)colAliasMatcher.group(1));
                    columnAlias = StringUtils.trimToEmpty((String)colAliasMatcher.group(2));
                } else {
                    columnName = StringUtils.trimToEmpty((String)currColumn);
                    columnAlias = null;
                }
                if (StringUtils.isBlank((CharSequence)columnName) && StringUtils.isNotBlank((CharSequence)columnAlias) || columnName.contains("<") || columnName.contains(">")) {
                    log.warn(String.format("malformed column to log definition '%s': %s", colsToLog, currColumn), (Object)0);
                }
                res.add(new ColumnAliasBean(columnName.toLowerCase(), columnAlias));
            }
        }
        return res;
    }

    public Integer getId() {
        return this.id;
    }

    public String getTablename() {
        return this.tablename;
    }

    public Integer getModificationLogLevel() {
        return this.modificationLogLevel;
    }
}

