/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.logging;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableOperationInfo;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.userinfo.DbTableUserInfo;
import de.riwagis.util.exception.SystemException;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DbTableLoggingSlf4jOperationExtender
extends DbTableOperationExtenderAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DbTableLoggingSlf4jOperationExtender.class);
    private final Logger LOG_DBTABLE;

    public DbTableLoggingSlf4jOperationExtender(String tableName) {
        this.LOG_DBTABLE = LoggerFactory.getLogger((String)(DbTable.class.getName() + "." + tableName));
    }

    public boolean isLoggerEnabled() {
        return this.LOG_DBTABLE.isTraceEnabled();
    }

    @Override
    public void afterOperation(DbTableOperationInfo operationInfo, DataTableQuery query, Collection<TableColumn> columns, DataRow row) throws SystemException {
        if (this.LOG_DBTABLE.isTraceEnabled()) {
            try {
                StringBuilder sbLogMessage = new StringBuilder();
                DbTable opTable = operationInfo.getDbTable();
                DbTableUserInfo userInfo = opTable.getUserInfo();
                MDC.put((String)"riwadatatable.tablename", (String)opTable.getTablename());
                MDC.put((String)"riwadatatable.username", (String)opTable.getTablename());
                MDC.put((String)"riwadatatable.userid", (String)opTable.getTablename());
                sbLogMessage.append("|").append(userInfo.getUserOrganisationID());
                sbLogMessage.append("|").append(userInfo.getUserOrganisationName());
                sbLogMessage.append("|").append(userInfo.getUserID());
                sbLogMessage.append("|").append(userInfo.getUserName());
                sbLogMessage.append("|").append(opTable.getTablename());
                sbLogMessage.append("|").append(operationInfo.getOperationType().getQueryStart());
                sbLogMessage.append("|").append(operationInfo.getRowsAffected());
                if (operationInfo.getOperationType() == DbTableOperationType.SELECT) {
                    if (columns != null) {
                        StringBuilder columnsText = new StringBuilder();
                        for (TableColumn opColumn : columns) {
                            if (columnsText.length() > 0) {
                                columnsText.append(',');
                            }
                            columnsText.append(opColumn.getColumnName());
                        }
                        columnsText.insert(0, operationInfo.getOperationType().getQueryStart() + " ");
                        sbLogMessage.append("|").append((CharSequence)columnsText);
                    } else {
                        sbLogMessage.append("|NO COLUMNS QUERY - COUNT,SUM");
                    }
                } else if (operationInfo.getOperationType() == DbTableOperationType.INSERT || operationInfo.getOperationType() == DbTableOperationType.UPDATE) {
                    StringBuilder dataText = new StringBuilder();
                    for (int i = 0; i < row.getColumnCount(); ++i) {
                        if (dataText.length() > 0) {
                            dataText.append(',');
                        }
                        dataText.append(row.getColumn(i)).append("=").append(row.getData(i));
                    }
                    sbLogMessage.append("|").append((CharSequence)dataText);
                } else {
                    sbLogMessage.append("|");
                }
                if (query != null) {
                    sbLogMessage.append("|").append(StringUtils.defaultIfEmpty((String)query.getSQLWhere(), (String)""));
                    StringBuilder criteriasText = new StringBuilder();
                    for (Object whereCriteria : query.getWhereCriterias(operationInfo.getConnInUse())) {
                        if (criteriasText.length() > 0) {
                            criteriasText.append(',');
                        }
                        criteriasText.append(whereCriteria);
                    }
                    sbLogMessage.append("|").append((CharSequence)criteriasText);
                } else {
                    sbLogMessage.append("|");
                    sbLogMessage.append("|");
                }
                this.LOG_DBTABLE.trace(sbLogMessage.toString());
            }
            catch (SQLException sqle) {
                throw new SystemException(String.format("Error logging DbTable operation: %s", sqle.getMessage()), (Throwable)sqle);
            }
            finally {
                MDC.remove((String)"riwadatatable.tablename");
                MDC.remove((String)"riwadatatable.username");
                MDC.remove((String)"riwadatatable.userid");
            }
        }
    }
}

