/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.logging;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.sequence.TableSequenceHandler;
import de.riwagis.riwadatatable.sequence.TableSequenceHandlerUtils;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableOperationInfo;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.extension.logging.DbTableLoggingInDbExtender;
import de.riwagis.riwadatatable.table.userinfo.DbTableUserInfo;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTableLoggingInDbOperationExtender
extends DbTableOperationExtenderAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DbTableLoggingInDbExtender.class);
    private final PreparedStatement pstmt;
    private final boolean isOracle;

    public DbTableLoggingInDbOperationExtender(Connection conn4Log, boolean isOracle) throws SystemException {
        try {
            this.isOracle = isOracle;
            this.pstmt = isOracle ? conn4Log.prepareStatement("insert into dbparser_log (id, exec_date, exec_type, username, exec_sql1, exec_sql2, exec_sql3, exec_sql4, tablename) values (?, ?, ?, ?, ?, ?, ?, ?, ?)") : conn4Log.prepareStatement("insert into dbparser_log (exec_date, exec_type, username, exec_sql1, exec_sql2, exec_sql3, exec_sql4, tablename) values (?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException sqle) {
            throw new SystemException(String.format("Error creating DbTableLoggingOperationExtender: %s", sqle.getMessage()), (Throwable)sqle);
        }
    }

    @Override
    public void close() throws Exception {
        DbUtils.closeQuietly((Statement)this.pstmt);
    }

    @Override
    public void afterOperation(DbTableOperationInfo operationInfo, DataTableQuery query, Collection<TableColumn> columns, DataRow row) throws SystemException {
        try {
            DbTable opTable = operationInfo.getDbTable();
            DbTableUserInfo userInfo = opTable.getUserInfo();
            this.pstmt.clearParameters();
            int pstmtIndex = 1;
            if (this.isOracle) {
                TableSequenceHandler tsh = TableSequenceHandlerUtils.buildTableSequenceHandler(opTable.getConnectionInfo().getDBType(), "dbparser_log_s", "id", "dbparser_log", false);
                Iterator<TableColumn> nextID = tsh.generateNextID(operationInfo.getConnInUse());
                this.pstmt.setObject(pstmtIndex, nextID);
                ++pstmtIndex;
            }
            this.pstmt.setTimestamp(pstmtIndex, DbTableLoggingInDbOperationExtender.buildTimestamp());
            this.pstmt.setInt(++pstmtIndex, operationInfo.getOperationType().getNumericValue());
            this.pstmt.setString(++pstmtIndex, userInfo.getUserName());
            ++pstmtIndex;
            if (operationInfo.getOperationType() == DbTableOperationType.SELECT) {
                if (columns != null) {
                    StringBuilder columnsText = new StringBuilder();
                    for (TableColumn opColumn : columns) {
                        if (columnsText.length() > 0) {
                            columnsText.append(',');
                        }
                        columnsText.append(opColumn.getColumnName());
                    }
                    columnsText.insert(0, operationInfo.getOperationType().getQueryStart() + " ");
                    this.pstmt.setString(pstmtIndex, StringUtils.abbreviate((String)columnsText.toString(), (int)2000));
                } else {
                    this.pstmt.setString(pstmtIndex, operationInfo.getOperationType().getQueryStart());
                }
            } else {
                this.pstmt.setString(pstmtIndex, String.format("%s %s rows", operationInfo.getOperationType().getQueryStart(), operationInfo.getRowsAffected()));
            }
            ++pstmtIndex;
            if (operationInfo.getOperationType() == DbTableOperationType.INSERT || operationInfo.getOperationType() == DbTableOperationType.UPDATE) {
                StringBuilder dataText = new StringBuilder();
                for (int i = 0; i < row.getColumnCount(); ++i) {
                    if (dataText.length() > 0) {
                        dataText.append('|');
                    }
                    dataText.append(row.getColumn(i)).append("=").append(row.getData(i));
                }
                this.pstmt.setString(pstmtIndex, StringUtils.abbreviate((String)dataText.toString(), (int)2000));
            } else {
                this.pstmt.setString(pstmtIndex, null);
            }
            ++pstmtIndex;
            if (query != null) {
                this.pstmt.setString(pstmtIndex, StringUtils.abbreviate((String)StringUtils.defaultIfEmpty((String)query.getSQLWhere(), (String)""), (int)2000));
                StringBuilder criteriasText = new StringBuilder();
                for (Object whereCriteria : query.getWhereCriterias(operationInfo.getConnInUse())) {
                    if (criteriasText.length() > 0) {
                        criteriasText.append('|');
                    }
                    criteriasText.append(whereCriteria);
                }
                this.pstmt.setString(++pstmtIndex, StringUtils.abbreviate((String)criteriasText.toString(), (int)2000));
                ++pstmtIndex;
            } else {
                this.pstmt.setString(pstmtIndex, null);
                this.pstmt.setString(++pstmtIndex, null);
                ++pstmtIndex;
            }
            this.pstmt.setString(pstmtIndex, opTable.getTablename());
            ++pstmtIndex;
            this.pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            throw new SystemException(String.format("Error logging DbTable operation in dbparser_log: %s", sqle.getMessage()), (Throwable)sqle);
        }
    }

    private static Timestamp buildTimestamp() {
        return new Timestamp(new Date().getTime());
    }
}

