/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.logging;

import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderPriority;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtender;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.extension.logging.DbTableEnhancedLogInDbOperationExtender;
import de.riwagis.riwadatatable.table.extension.logging.DbTableLoggingInDbOperationExtender;
import de.riwagis.riwadatatable.table.extension.logging.query.LogConfigEntry;
import de.riwagis.riwadatatable.table.extension.logging.query.LogConfigReader;
import de.riwagis.riwadatatable.table.extension.logging.utils.ColumnAliasBean;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.jdbc.ConnectionUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTableLoggingInDbExtender
extends DbTableExtenderAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DbTableLoggingInDbExtender.class);
    private boolean logTableExists = true;
    private boolean logConfigTableExists = false;
    private List<ColumnAliasBean> additionalColsToLog = null;
    private Integer modifLogLevel = null;
    private final DbTable dbTable;
    private boolean enableModificationLog;

    public DbTableLoggingInDbExtender(DbTable dbTable) {
        this(dbTable, false);
    }

    public DbTableLoggingInDbExtender(DbTable dbTable, boolean enableModificationLog) {
        super(DbTableExtenderPriority.LAST);
        this.dbTable = dbTable;
        this.enableModificationLog = enableModificationLog;
    }

    @Override
    public DbTableOperationExtender createOperationExtender(DbTableOperationType type, Connection conn) throws SystemException {
        if (type == DbTableOperationType.SELECT) {
            if (this.dbTable.getTableDefinition().getSelectlog() != 0) {
                if (this.logTableExists) {
                    if (this.logConfigTableExists) {
                        return new DbTableEnhancedLogInDbOperationExtender(conn, this.additionalColsToLog, this.modifLogLevel, this.dbTable.getConnectionInfo().isOracle());
                    }
                    return new DbTableLoggingInDbOperationExtender(conn, this.dbTable.getConnectionInfo().isOracle());
                }
                if (this.dbTable.getTableDefinition().getSelectlog() == 1) {
                    throw new SystemException(String.format("Tablescheme: %s. Logging of changes in table dbparser_log not possible. Make sure table exits.", this.dbTable.getConnectionInfo().getScheme()));
                }
            }
        } else if (this.dbTable.getTableDefinition().getChangelog() != 0) {
            if (this.logTableExists) {
                if (this.logConfigTableExists) {
                    DbTableEnhancedLogInDbOperationExtender opExtender = new DbTableEnhancedLogInDbOperationExtender(conn, this.additionalColsToLog, this.enableModificationLog, this.modifLogLevel, this.dbTable.getConnectionInfo().isOracle());
                    return opExtender;
                }
                return new DbTableLoggingInDbOperationExtender(conn, this.dbTable.getConnectionInfo().isOracle());
            }
            if (this.dbTable.getTableDefinition().getChangelog() == 1) {
                throw new SystemException(String.format("Tablescheme: %s. Logging of changes in table dbparser_log not possible. Make sure table exits.", this.dbTable.getConnectionInfo().getScheme()));
            }
        }
        return null;
    }

    private static boolean checkTableExists(Connection conn, String tableName) {
        boolean res = false;
        try {
            res = ConnectionUtils.tableExists((Connection)conn, (String)tableName);
        }
        catch (SQLException se) {
            LOG.error(String.format("Error detecting if table '%s' exists in connection '%s': %s", tableName, conn, se.getMessage()));
        }
        if (!res) {
            LOG.debug(String.format("No '%s' found in connection '%s'.", tableName, conn));
        }
        return res;
    }

    private static Pair<Integer, List<ColumnAliasBean>> getAdditionalCols2LogConfig(Connection conn, DbTable table2Log) {
        Integer modificationLogLevel = null;
        ArrayList<ColumnAliasBean> colsToLogResult = new ArrayList<ColumnAliasBean>();
        try {
            LogConfigEntry lce = LogConfigReader.read(conn, table2Log.getTablename());
            if (lce != null) {
                colsToLogResult.addAll(lce.getColumnsToLog());
                modificationLogLevel = lce.getModificationLogLevel();
            }
        }
        catch (SQLException eatit) {
            LOG.warn(String.format("error accessing dbparser_log_config for table '%s': %s", table2Log.getTablename(), eatit.getMessage()), (Throwable)eatit);
        }
        if (table2Log.hasIDColumn()) {
            String idCol = table2Log.getIDColumn().getColumnName().toLowerCase();
            if (colsToLogResult.stream().noneMatch(tmpColAlias -> tmpColAlias.getColumnName().equalsIgnoreCase(idCol))) {
                colsToLogResult.add(0, new ColumnAliasBean(idCol));
            }
        }
        return Pair.of(modificationLogLevel, colsToLogResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterInitialisation(DbTable dbTable) throws SystemException {
        Connection conn;
        JDBCConnectionManager connmngr;
        block6: {
            connmngr = dbTable.getConnectionManagerInternal();
            conn = connmngr.createConnection();
            try {
                this.logTableExists = DbTableLoggingInDbExtender.checkTableExists(conn, "dbparser_log");
                if (!this.logTableExists) break block6;
                this.logConfigTableExists = DbTableLoggingInDbExtender.checkTableExists(conn, "dbparser_log_config");
                if (!this.logConfigTableExists) break block6;
                Pair<Integer, List<ColumnAliasBean>> cols2LogConfig = DbTableLoggingInDbExtender.getAdditionalCols2LogConfig(conn, dbTable);
                this.additionalColsToLog = (List)cols2LogConfig.getRight();
                this.modifLogLevel = (Integer)cols2LogConfig.getLeft();
            }
            catch (Throwable throwable) {
                try {
                    connmngr.closeConnection(conn);
                }
                catch (SystemException eatit) {
                    LOG.trace(String.format("unable to close connection: %s", eatit.getMessage()), (Throwable)eatit);
                }
                throw throwable;
            }
        }
        try {
            connmngr.closeConnection(conn);
        }
        catch (SystemException eatit) {
            LOG.trace(String.format("unable to close connection: %s", eatit.getMessage()), (Throwable)eatit);
        }
    }
}

