/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.logging;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.data.DataRowReader;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.sequence.TableSequenceHandler;
import de.riwagis.riwadatatable.sequence.TableSequenceHandlerUtils;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableOperationInfo;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.extension.logging.utils.ColumnAliasBean;
import de.riwagis.riwadatatable.table.extension.logging.utils.ColumnInfo;
import de.riwagis.riwadatatable.table.userinfo.DbTableUserInfo;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.WordUtils;

public class DbTableEnhancedLogInDbOperationExtender
extends DbTableOperationExtenderAdapter {
    private static final int MAX_ROW_COUNT_4_MODIFICATION_LOGGING = 100;
    private static final int MAX_COLUMN_CHUNK_SIZE = 60000;
    private static final String SEPARATOR_PRIMARYKEY = ",";
    private static final String SEPARATOR_PRIMARYKEY_CHUNK = ";";
    private static final String MAX_MODIF_LOGGING_EXCEEDED_MESSAGE = "Zu viele Datens\u00e4tze von der Operation betroffen, Detailprotokollierung deaktiviert.";
    private final PreparedStatement pstmt;
    private final Connection conn;
    private final boolean isOracle;
    private final List<ColumnAliasBean> additionalCols2Log;
    private final Collection<Object> affectedPks;
    private final List<ColumnInfo> additionalCols;
    private final Integer modifLogLevel;
    private final List<ColumnInfo> colsBeforeModifiction;
    private final boolean modificationLogEnabled;
    private boolean maxDataCount4EnhancedLoggingExcceded = false;
    private static final DecimalFormat DF_PK = DbTableEnhancedLogInDbOperationExtender.buildPKDateformat();

    private static DecimalFormat buildPKDateformat() {
        DecimalFormat tempDF = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        tempDF.setMaximumFractionDigits(340);
        tempDF.setMaximumIntegerDigits(309);
        return tempDF;
    }

    public DbTableEnhancedLogInDbOperationExtender(Connection conn4Log, boolean isOracle) throws SystemException {
        this(conn4Log, null, false, null, isOracle);
    }

    DbTableEnhancedLogInDbOperationExtender(Connection conn, List<ColumnAliasBean> additionalColsToLog, Integer modifLogLevel, boolean oracle) throws SystemException {
        this(conn, additionalColsToLog, false, modifLogLevel, oracle);
    }

    public DbTableEnhancedLogInDbOperationExtender(Connection conn4Log, List<ColumnAliasBean> additionalCols2Log, boolean enableModificationLogging, Integer modifLogLevel, boolean isOracle) throws SystemException {
        try {
            this.conn = conn4Log;
            this.isOracle = isOracle;
            this.affectedPks = new LinkedHashSet<Object>();
            this.additionalCols = new ArrayList<ColumnInfo>();
            this.modifLogLevel = modifLogLevel;
            this.additionalCols2Log = additionalCols2Log != null ? additionalCols2Log : new ArrayList();
            this.modificationLogEnabled = enableModificationLogging;
            this.colsBeforeModifiction = new ArrayList<ColumnInfo>();
            this.pstmt = isOracle ? conn4Log.prepareStatement("INSERT INTO dbparser_log   (id, exec_date, exec_type, username, exec_sql1, exec_sql2, exec_sql3, exec_sql4, tablename, additional_cols, exec_sql2_ori, affected_pk)  VALUES   (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)") : conn4Log.prepareStatement("INSERT INTO dbparser_log   (exec_date, exec_type, username, exec_sql1, exec_sql2, exec_sql3, exec_sql4, tablename, additional_cols, exec_sql2_ori, affected_pk)  VALUES   (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException sqle) {
            throw new SystemException(String.format("Error creating DbTableLoggingOperationExtender: %s", sqle.getMessage()), (Throwable)sqle);
        }
    }

    @Override
    public void close() throws Exception {
        DbUtils.closeQuietly((Statement)this.pstmt);
    }

    @Override
    public void beforeOperation(DbTableOperationInfo operationInfo, DataTableQuery query, Collection<TableColumn> columns, DataRow row) throws SystemException {
        this.clearCache();
        if (operationInfo.getOperationType().isOneOf(DbTableOperationType.UPDATE, DbTableOperationType.DELETE) && this.isModificationLogEnabled()) {
            this.fillCols4Query(operationInfo, query != null ? query : new DataTableQuery(), true, row);
        } else if (operationInfo.getOperationType() == DbTableOperationType.DELETE) {
            this.fillCols4Query(operationInfo, query != null ? query : new DataTableQuery(), true, false, row);
        }
    }

    @Override
    public void afterOperation(DbTableOperationInfo operationInfo, DataTableQuery query, Collection<TableColumn> columns, DataRow row) throws SystemException {
        try {
            DbTable opTable = operationInfo.getDbTable();
            DbTableUserInfo userInfo = opTable.getUserInfo();
            this.pstmt.clearParameters();
            int pstmtIndex = this.isOracle ? 1 : 0;
            TableSequenceHandler tsh = this.isOracle ? TableSequenceHandlerUtils.buildTableSequenceHandler(opTable.getConnectionInfo().getDBType(), "dbparser_log_s", "id", "dbparser_log", false) : null;
            this.pstmt.setTimestamp(++pstmtIndex, DbTableEnhancedLogInDbOperationExtender.buildTimestamp());
            this.pstmt.setInt(++pstmtIndex, operationInfo.getOperationType().getNumericValue());
            this.pstmt.setString(++pstmtIndex, userInfo.getUserName());
            if (operationInfo.getOperationType() == DbTableOperationType.SELECT) {
                if (columns != null) {
                    StringBuilder columnsText = new StringBuilder();
                    for (TableColumn opColumn : columns) {
                        if (columnsText.length() > 0) {
                            columnsText.append(',');
                        }
                        columnsText.append(opColumn.getColumnName());
                    }
                    columnsText.insert(0, operationInfo.getOperationType().getQueryStart() + " ");
                    this.pstmt.setString(++pstmtIndex, StringUtils.abbreviate((String)columnsText.toString(), (int)2000));
                } else {
                    this.pstmt.setString(++pstmtIndex, operationInfo.getOperationType().getQueryStart());
                }
            } else {
                this.pstmt.setString(++pstmtIndex, String.format("%s %s rows", operationInfo.getOperationType().getQueryStart(), operationInfo.getRowsAffected()));
            }
            if (operationInfo.getOperationType() == DbTableOperationType.INSERT || operationInfo.getOperationType() == DbTableOperationType.UPDATE) {
                StringBuilder dataText = new StringBuilder();
                for (int i = 0; i < row.getColumnCount(); ++i) {
                    if (dataText.length() > 0) {
                        dataText.append('|');
                    }
                    dataText.append(row.getColumn(i)).append("=").append(row.getData(i));
                }
                this.pstmt.setString(++pstmtIndex, StringUtils.abbreviate((String)dataText.toString(), (int)2000));
            } else {
                this.pstmt.setString(++pstmtIndex, null);
            }
            if (query != null) {
                this.pstmt.setString(++pstmtIndex, StringUtils.abbreviate((String)StringUtils.defaultIfEmpty((String)query.getSQLWhere(), (String)""), (int)2000));
                StringBuilder criteriasText = new StringBuilder();
                for (Object whereCriteria : query.getWhereCriterias(operationInfo.getConnInUse())) {
                    if (criteriasText.length() > 0) {
                        criteriasText.append('|');
                    }
                    criteriasText.append(whereCriteria);
                }
                this.pstmt.setString(++pstmtIndex, StringUtils.abbreviate((String)criteriasText.toString(), (int)2000));
            } else {
                this.pstmt.setString(++pstmtIndex, null);
                this.pstmt.setString(++pstmtIndex, null);
            }
            this.pstmt.setString(++pstmtIndex, opTable.getTablename());
            if (operationInfo.getOperationType() != DbTableOperationType.DELETE) {
                this.fillAdditionalCols2Log(operationInfo, query, row);
            }
            this.setEnhancedLoggingValue(this.pstmt, ++pstmtIndex, this.additionalCols);
            this.setEnhancedLoggingValue(this.pstmt, ++pstmtIndex, this.colsBeforeModifiction);
            String collectedPks = this.affectedPks.isEmpty() ? "" : this.affectedPks.stream().map(item -> DbTableEnhancedLogInDbOperationExtender.convertObjectToPK(item)).collect(Collectors.joining(SEPARATOR_PRIMARYKEY));
            List<String> pkChunks = DbTableEnhancedLogInDbOperationExtender.chunkText(collectedPks, 60000);
            int index2set = ++pstmtIndex;
            for (String currentChunk : pkChunks) {
                if (tsh != null) {
                    this.pstmt.setObject(1, tsh.generateNextID(operationInfo.getConnInUse()));
                }
                this.pstmt.setString(index2set, StringUtils.isBlank((String)currentChunk) ? null : currentChunk);
                this.pstmt.executeUpdate();
            }
        }
        catch (SQLException sqle) {
            throw new SystemException(String.format("Error logging DbTable operation in dbparser_log: %s", sqle.getMessage()), (Throwable)sqle);
        }
    }

    public static String convertObjectToPK(Object item) {
        if (item instanceof Number) {
            return DF_PK.format((Number)item);
        }
        return String.valueOf(item);
    }

    private void fillAdditionalCols2Log(DbTableOperationInfo operationInfo, DataTableQuery query, DataRow row) throws SystemException {
        if (query != null) {
            this.fillCols4Query(operationInfo, query, false, row);
        } else {
            String idCol = null;
            if (operationInfo.getDbTable().hasIDColumn()) {
                this.affectedPks.add(operationInfo.getDbTable().getIDLastInsert());
                idCol = operationInfo.getDbTable().getIDColumn().getColumnName().toLowerCase();
            }
            if (!this.additionalCols2Log.isEmpty()) {
                ColumnInfo tmpCols2Log = new ColumnInfo();
                for (ColumnAliasBean tmpCol : this.additionalCols2Log) {
                    if (!tmpCol.getColumnName().equalsIgnoreCase(idCol)) {
                        tmpCols2Log.addColumnValue(tmpCol.getColumnName2Log(), row.hasColumn(tmpCol.getColumnName()) ? (row.getData(tmpCol.getColumnName()) != null ? row.getDataAsString(tmpCol.getColumnName()) : null) : null);
                        continue;
                    }
                    tmpCols2Log.addColumnValue(tmpCol.getColumnName(), String.valueOf(operationInfo.getDbTable().getIDLastInsert()));
                }
                this.additionalCols.add(tmpCols2Log);
            }
        }
    }

    private void fillCols4Query(DbTableOperationInfo operationInfo, DataTableQuery query, boolean beforeOperation, boolean logAdditionalCols, DataRow modOperationDataRow) throws SystemException {
        boolean hasIdColumn = operationInfo.getDbTable().hasIDColumn();
        int tmpSelectLog = operationInfo.getDbTable().getTableDefinition().getSelectlog();
        operationInfo.getDbTable().setLogSelects(0);
        this.maxDataCount4EnhancedLoggingExcceded = operationInfo.getDbTable().getCount(this.conn, query) > 100;
        try (DataRowReader dataReader = operationInfo.getDbTable().getData(this.conn, query, operationInfo.getDbTable().getColumnNames());){
            while (dataReader.hasNext()) {
                DataRow dataRow = (DataRow)dataReader.next();
                if (!this.maxDataCount4EnhancedLoggingExcceded) {
                    ColumnInfo tmpCols2Log;
                    if (!(!logAdditionalCols || beforeOperation && operationInfo.getOperationType() != DbTableOperationType.DELETE || this.additionalCols2Log.isEmpty())) {
                        tmpCols2Log = new ColumnInfo();
                        for (ColumnAliasBean tmpColAlias : this.additionalCols2Log) {
                            tmpCols2Log.addColumnValue(tmpColAlias.getColumnName2Log(), dataRow.getData(tmpColAlias.getColumnName()) != null ? dataRow.getDataAsString(tmpColAlias.getColumnName()) : null);
                        }
                        this.additionalCols.add(tmpCols2Log);
                    }
                    if (beforeOperation && this.isModificationLogEnabled()) {
                        DataRow rowBeforeOperation;
                        tmpCols2Log = new ColumnInfo("|");
                        DataRow dataRow2 = rowBeforeOperation = modOperationDataRow != null ? modOperationDataRow : dataRow;
                        if (rowBeforeOperation != null) {
                            for (String tmpColName : rowBeforeOperation.getColumnNames()) {
                                tmpCols2Log.addColumnValue(tmpColName, dataRow.getData(tmpColName.toLowerCase()) != null ? dataRow.getDataAsString(tmpColName.toLowerCase()) : null);
                            }
                        }
                        this.colsBeforeModifiction.add(tmpCols2Log);
                    }
                }
                if (!hasIdColumn) continue;
                this.affectedPks.add(dataRow.getData(operationInfo.getDbTable().getIDColumn().getColumnName()));
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            operationInfo.getDbTable().setLogSelects(tmpSelectLog);
        }
    }

    private void fillCols4Query(DbTableOperationInfo operationInfo, DataTableQuery query, boolean beforeOperation, DataRow row) throws SystemException {
        this.fillCols4Query(operationInfo, query, beforeOperation, true, row);
    }

    private static Timestamp buildTimestamp() {
        return new Timestamp(new Date().getTime());
    }

    private boolean isModificationLogEnabled() {
        return this.modifLogLevel == null ? this.modificationLogEnabled : this.modifLogLevel == 1 || this.modificationLogEnabled && this.modifLogLevel != 0;
    }

    private void setEnhancedLoggingValue(PreparedStatement stmt, int pstmtIndex, List<ColumnInfo> cols2log) throws SQLException {
        if (this.maxDataCount4EnhancedLoggingExcceded) {
            stmt.setString(pstmtIndex, MAX_MODIF_LOGGING_EXCEEDED_MESSAGE);
        } else if (!cols2log.isEmpty()) {
            stmt.setString(pstmtIndex, StringUtils.abbreviate((String)ColumnInfo.toPrettyString(cols2log), (int)60000));
        } else {
            stmt.setString(pstmtIndex, null);
        }
    }

    public static List<String> chunkText(String text, int maxChunkSize) {
        String trimmedText = StringUtils.trimToEmpty((String)text);
        if (StringUtils.isNotBlank((String)trimmedText) && trimmedText.length() > maxChunkSize) {
            return Arrays.asList(WordUtils.wrap((String)trimmedText, (int)maxChunkSize, (String)SEPARATOR_PRIMARYKEY_CHUNK, (boolean)false, (String)SEPARATOR_PRIMARYKEY).split(SEPARATOR_PRIMARYKEY_CHUNK));
        }
        return List.of(trimmedText);
    }

    private void clearCache() {
        this.additionalCols.clear();
        this.affectedPks.clear();
        this.colsBeforeModifiction.clear();
    }
}

