/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.locking;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.data.DataRowReader;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableOperationInfo;
import de.riwagis.riwadatatable.table.extension.locking.DbTableLockExtender;
import de.riwagis.riwadatatable.table.extension.locking.LockModeTbd;
import de.riwagis.riwadatatable.table.extension.presetvalues.DbTableDefaultPresetColumns;
import de.riwagis.util.exception.SystemException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang.ObjectUtils;

public class DbTableLockOperationExtender
extends DbTableOperationExtenderAdapter {
    private final DbTableLockExtender lockHandler;

    DbTableLockOperationExtender(DbTableLockExtender lockHandler) {
        this.lockHandler = lockHandler;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String isOperationAllowed(DbTableOperationInfo operationInfo, DataTableQuery query, Collection<TableColumn> columns, DataRow row) throws SystemException {
        switch (operationInfo.getOperationType()) {
            case DELETE: {
                if (this.lockHandler.isDataLocked(operationInfo.getConnInUse(), query)) {
                    return "Operation is not allowed. Datasets affected by this operation are locked.";
                }
                return null;
            }
            case UPDATE: {
                if (this.lockHandler.isDataLocked(operationInfo.getConnInUse(), query)) {
                    LockModeTbd lockMode = this.lockHandler.getLockModeTBD(operationInfo.getConnInUse(), query);
                    switch (lockMode) {
                        case FULL_LOCK: {
                            return "Operation is not allowed. Datasets affected by this operation are locked.";
                        }
                        case UPDATE_ACTIVE_FLAG_ALLOWED: {
                            try (DataRowReader data = operationInfo.getDbTable().getData(operationInfo.getConnInUse(), query, (Collection<String>)columns.stream().map(col -> col.getColumnName()).collect(Collectors.toList()));){
                                if (!data.hasNext()) break;
                                DataRow formerRow = (DataRow)data.next();
                                for (String currCol : formerRow.getColumnNames()) {
                                    if (ObjectUtils.equals((Object)formerRow.getDataAsString(currCol), (Object)row.getDataAsString(currCol)) || "active".equalsIgnoreCase(currCol) || DbTableDefaultPresetColumns.isDefaultPresetColumn(currCol)) continue;
                                    String string = "Operation is not allowed. Datasets affected by this operation are locked.";
                                    return string;
                                }
                                break;
                            }
                            catch (SystemException e) {
                                throw e;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    return null;
                }
                return null;
            }
        }
        return null;
    }
}

