/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.locking;

import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.data.DataRowReader;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.DefaultTableDefinition;
import de.riwagis.riwadatatable.table.TableDefinition;
import de.riwagis.riwadatatable.table.extension.locking.DbTableLockInfo;
import de.riwagis.riwadatatable.table.extension.locking.NoLockInfoFoundException;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;

public class DbTableLockInfoUtils {
    public static TableDefinition getLockInfoTableDefinition() {
        DefaultTableDefinition tableDefInfoTable = new DefaultTableDefinition();
        tableDefInfoTable.setName("riwa_lock_info");
        tableDefInfoTable.setIdColumn("id");
        tableDefInfoTable.setOrder("id");
        tableDefInfoTable.setUpdate(1);
        tableDefInfoTable.setDelete(1);
        tableDefInfoTable.setInsert(1);
        return tableDefInfoTable;
    }

    public static DbTable getLockInfoTable(DbTable dbTable2DeriveFrom) throws SystemException, SQLException {
        return dbTable2DeriveFrom.deriveDbTable(DbTableLockInfoUtils.getLockInfoTableDefinition(), null);
    }

    public static List<DbTableLockInfo> getTableLockInfos(Connection connOrNull, DbTable lockInfoTable) throws SystemException {
        ArrayList<DbTableLockInfo> lockInfos = new ArrayList<DbTableLockInfo>();
        List<String> columns = Arrays.asList("id", "value");
        DataRowReader reader = null;
        try {
            reader = connOrNull == null ? lockInfoTable.getData(new DataTableQuery(lockInfoTable.getConnectionInfo()), columns) : lockInfoTable.getData(connOrNull, new DataTableQuery(lockInfoTable.getConnectionInfo()), columns);
            while (reader.hasNext()) {
                DataRow infoRow = (DataRow)reader.next();
                lockInfos.add(new DbTableLockInfo(((Number)infoRow.getData(0)).intValue(), ObjectUtils.toString((Object)infoRow.getData(1))));
            }
        }
        catch (Exception e) {
            throw new SystemException("Error retrieving lock information: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.closeQuietly();
            }
        }
        return lockInfos;
    }

    public static DbTableLockInfo getTableLockInfo(Connection connOrNull, DbTable lockInfoTable, int lockID) throws SystemException {
        List<String> columns = Arrays.asList("id", "value");
        DataTableQuery query = new DataTableQuery(lockInfoTable.getConnectionInfo(), "id=?", lockID);
        DataRowReader reader = null;
        try {
            reader = connOrNull == null ? lockInfoTable.getData(query, columns) : lockInfoTable.getData(connOrNull, query, columns);
            if (reader.hasNext()) {
                DataRow infoRow = (DataRow)reader.next();
                DbTableLockInfo dbTableLockInfo = new DbTableLockInfo(((Number)infoRow.getData(0)).intValue(), ObjectUtils.toString((Object)infoRow.getData(1)));
                return dbTableLockInfo;
            }
        }
        catch (Exception e) {
            throw new SystemException("Error retrieving lock information: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.closeQuietly();
            }
        }
        throw new NoLockInfoFoundException(String.format("No lock information found for given lock id: '%s'", lockID));
    }

    public static synchronized DbTableLockInfo createAndGetNextLock(Connection connOrNull, DbTable lockInfoTable, String lockInformation) throws SystemException {
        List<DbTableLockInfo> lockInfos = DbTableLockInfoUtils.getTableLockInfos(connOrNull, lockInfoTable);
        int nextLockId = Integer.MIN_VALUE;
        for (DbTableLockInfo lockInfo : lockInfos) {
            if (nextLockId >= lockInfo.getLockID()) continue;
            nextLockId = lockInfo.getLockID() + 1;
        }
        DataRow row2Insert = new DataRow(lockInfoTable.getColumnsCollection("id", "value"), nextLockId, lockInformation);
        if (connOrNull == null) {
            lockInfoTable.insertData(row2Insert);
        } else {
            lockInfoTable.insertData(connOrNull, row2Insert);
        }
        nextLockId = ((Number)lockInfoTable.getIDLastInsert()).intValue();
        return new DbTableLockInfo(nextLockId, lockInformation);
    }

    public static void deleteAllLockInfos(Connection connOrNull, DbTable lockInfoTable) throws SystemException {
        DataTableQuery query = new DataTableQuery(lockInfoTable.getConnectionInfo());
        if (connOrNull == null) {
            lockInfoTable.deleteData(query);
        } else {
            lockInfoTable.deleteData(connOrNull, query);
        }
    }

    public static int deleteLockInfo(Connection connOrNull, DbTable lockInfoTable, Integer lockID) throws SystemException {
        DataTableQuery query = new DataTableQuery(lockInfoTable.getConnectionInfo(), "id=?", lockID);
        if (connOrNull == null) {
            return lockInfoTable.deleteData(query);
        }
        return lockInfoTable.deleteData(connOrNull, query);
    }
}

