/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.locking;

import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.data.DataRowReader;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderPriority;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtender;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.extension.locking.DbTableLockInfo;
import de.riwagis.riwadatatable.table.extension.locking.DbTableLockInfoUtils;
import de.riwagis.riwadatatable.table.extension.locking.DbTableLockOperationExtender;
import de.riwagis.riwadatatable.table.extension.locking.LockModeTbd;
import de.riwagis.riwadatatable.table.extension.locking.NoLockInfoFoundException;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public class DbTableLockExtender
extends DbTableExtenderAdapter {
    public static final String COLUMN_LOCKED_DEFAULT = "locked_by_id";
    public static final String COLUMN_LOCK_MODE_TBD = "lock_mode_tbd";
    public static final String TABLE_LOCKINFO_DEFAULT = "riwa_lock_info";
    private final AtomicBoolean inUnlock = new AtomicBoolean(false);
    private final String lockColumnName;
    private final DbTable dbTable;
    private final DbTable dbTableInfo;
    private final DbTableLockOperationExtender operationExtender;

    public DbTableLockExtender(DbTable dbTable) {
        this(dbTable, COLUMN_LOCKED_DEFAULT);
    }

    public DbTableLockExtender(DbTable dbTable, String lockColumnName) {
        super(DbTableExtenderPriority.NORMAL);
        this.lockColumnName = lockColumnName;
        this.dbTable = dbTable;
        this.operationExtender = new DbTableLockOperationExtender(this);
        this.dbTableInfo = DbTableLockExtender.getLockInfoTable(this.dbTable);
    }

    public String getLockColumnName() {
        return this.lockColumnName;
    }

    private void checkDbTable() throws IllegalStateException {
        if (this.dbTable == null) {
            throw new IllegalStateException("LockHandler is not initialized. Link to DbTable object is missing.");
        }
    }

    public boolean lockColumnExists() {
        return this.dbTable.hasColumn(this.lockColumnName);
    }

    public boolean lockModeColumnExists() {
        return this.dbTable.hasColumn(COLUMN_LOCK_MODE_TBD);
    }

    public String getLockModeColumnName() {
        return COLUMN_LOCK_MODE_TBD;
    }

    public String getLockInfo(Connection connOrNull, Object objID) throws SystemException {
        Object lockObj;
        DataRow result;
        this.checkDbTable();
        if (objID == null) {
            throw new IllegalArgumentException(String.format("Error retrieving lock information. Null values for PrimaryKey values are not allowed. Table: '%s'", this.dbTable.getTablename()));
        }
        String lockColumnInternal = this.getLockColumnName();
        if (this.dbTable.hasColumn(lockColumnInternal) && this.lockInfoTableExists() && (result = this.dbTable.getData(objID, Arrays.asList(lockColumnInternal))) != null && (lockObj = result.getData(this.lockColumnName)) != null && lockObj instanceof Number) {
            try {
                DbTableLockInfo lockInfo = DbTableLockInfoUtils.getTableLockInfo(connOrNull, this.dbTableInfo, ((Number)lockObj).intValue());
                return lockInfo.getLockInfo();
            }
            catch (NoLockInfoFoundException noLockInfoFoundException) {
                // empty catch block
            }
        }
        return "";
    }

    public boolean isDataLocked(Connection connOrNull, Object objID) throws SystemException {
        DataRow row;
        if (this.inUnlock.get()) {
            return false;
        }
        return this.lockColumnExists() && (row = connOrNull == null ? this.dbTable.getData(objID, this.getLockColumnName()) : this.dbTable.getData(connOrNull, objID, this.getLockColumnName())) != null && row.getData(this.getLockColumnName()) != null;
    }

    public LockModeTbd getLockModeTBD(Connection connOrNull, Object objID) throws SystemException {
        Number mode;
        DataRow row;
        if (this.lockModeColumnExists() && (row = connOrNull == null ? this.dbTable.getData(objID, this.getLockModeColumnName()) : this.dbTable.getData(connOrNull, objID, this.getLockModeColumnName())) != null && (mode = (Number)row.getData(this.getLockModeColumnName())) != null) {
            return LockModeTbd.getLockMode(mode.intValue());
        }
        return LockModeTbd.FULL_LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LockModeTbd getLockModeTBD(Connection connOrNull, DataTableQuery query) throws SystemException {
        try {
            if (!this.lockModeColumnExists()) return LockModeTbd.FULL_LOCK;
            DataRowReader rowReader = connOrNull == null ? this.dbTable.getData(query, this.getLockModeColumnName()) : this.dbTable.getData(connOrNull, query, this.getLockModeColumnName());
            try {
                if (!rowReader.hasNext()) return LockModeTbd.FULL_LOCK;
                DataRow row = (DataRow)rowReader.next();
                Number mode = (Number)row.getData(this.getLockModeColumnName());
                if (mode == null) return LockModeTbd.FULL_LOCK;
                LockModeTbd lockModeTbd = LockModeTbd.getLockMode(mode.intValue());
                return lockModeTbd;
            }
            finally {
                rowReader.closeQuietly();
            }
        }
        catch (Exception e) {
            if (!(e instanceof SystemException)) throw new SystemException(this.getClass(), "Error at getLockMode. " + e.getMessage(), (Throwable)e);
            throw (SystemException)((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDataLocked(Connection connOrNull, DataTableQuery query) throws SystemException {
        try {
            if (this.inUnlock.get()) {
                return false;
            }
            if (!this.lockColumnExists()) return false;
            DataRowReader rowReader = connOrNull == null ? this.dbTable.getData(query, this.getLockColumnName()) : this.dbTable.getData(connOrNull, query, this.getLockColumnName());
            try {
                DataRow row;
                do {
                    if (!rowReader.hasNext()) return false;
                } while ((row = (DataRow)rowReader.next()).getData(this.getLockColumnName()) == null);
                boolean bl = true;
                return bl;
            }
            finally {
                rowReader.closeQuietly();
            }
        }
        catch (Exception e) {
            if (!(e instanceof SystemException)) throw new SystemException(this.getClass(), "Error at isDataLocked. " + e.getMessage(), (Throwable)e);
            throw (SystemException)((Object)e);
        }
    }

    public int lockData(Connection connOrNull, DataTableQuery query, int lockId) throws SystemException {
        if (this.lockColumnExists()) {
            DataRow data2update = new DataRow(this.dbTable.getColumnsCollection(this.getLockColumnName()), lockId);
            if (connOrNull == null) {
                return this.dbTable.updateData(data2update, query);
            }
            return this.dbTable.updateData(connOrNull, data2update, query);
        }
        throw new SystemException("Lock column " + this.getLockColumnName() + " not found in table " + this.dbTable.getTablename());
    }

    public int lockData(Connection connOrNull, Object objID, int lockId) throws SystemException {
        DataTableQuery query = new DataTableQuery(this.dbTable.getConnectionInfo(), String.format("%s=?", this.dbTable.getIDColumn().getColumnName()), objID);
        return this.lockData(connOrNull, query, lockId);
    }

    public int unlockData(Connection connOrNull, DataTableQuery query) throws SystemException {
        this.inUnlock.set(true);
        try {
            if (this.lockColumnExists()) {
                DataRow data2update = new DataRow(this.dbTable.getColumnsCollection(this.getLockColumnName()), new Object[]{null});
                if (connOrNull == null) {
                    int n = this.dbTable.updateData(data2update, query);
                    return n;
                }
                int n = this.dbTable.updateData(connOrNull, data2update, query);
                return n;
            }
            throw new SystemException("Lock column " + this.getLockColumnName() + " not found in table " + this.dbTable.getTablename());
        }
        finally {
            this.inUnlock.set(false);
        }
    }

    public int unlockData(Connection connOrNull, Object objID) throws SystemException {
        DataTableQuery query = new DataTableQuery(this.dbTable.getConnectionInfo(), String.format("%s=?", this.dbTable.getIDColumn().getColumnName()), objID);
        return this.unlockData(connOrNull, query);
    }

    @Override
    public DbTableOperationExtender createOperationExtender(DbTableOperationType type, Connection conn) {
        return this.operationExtender;
    }

    public boolean lockInfoTableExists() {
        return this.dbTableInfo != null;
    }

    public DbTable getLockInfoTable() {
        return this.dbTableInfo;
    }

    private static DbTable getLockInfoTable(DbTable tableToDeriveFrom) {
        try {
            return DbTableLockInfoUtils.getLockInfoTable(tableToDeriveFrom);
        }
        catch (Exception e) {
            return null;
        }
    }
}

