/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.label;

import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.label.LabelDefInfo;
import de.riwagis.label.LabelFeatureAction;
import de.riwagis.label.LabelFeatureAtts;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableOperationInfo;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.extension.label.DbTableCRUDLabelsUtil;
import de.riwagis.riwadatatable.table.geotools.FeatureDbTable;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.FeatureReader;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTableLabelOperationExtender
extends DbTableOperationExtenderAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DbTableLabelOperationExtender.class);
    private final FeatureDbTable parentTable;
    private final FeatureDbTable labelTable;
    private final DbTableCRUDLabelsUtil labelsUtil;

    DbTableLabelOperationExtender(FeatureDbTable parentTable, FeatureDbTable labelTable, List<LabelDefInfo> labelInfos, Connection conn2use) {
        this.labelsUtil = new DbTableCRUDLabelsUtil(parentTable, labelTable, labelInfos, conn2use);
        this.parentTable = parentTable;
        this.labelTable = labelTable;
        if (!parentTable.hasIDColumn()) {
            throw new IllegalArgumentException(String.format("Error creating DbTableLabelOperationExtender. Given parent table '%s' has to have an PrimaryKey column.", parentTable.getTablename()));
        }
        if (!labelTable.hasIDColumn()) {
            throw new IllegalArgumentException(String.format("Error creating DbTableLabelOperationExtender. Given label table '%s' has to have an PrimaryKey column.", labelTable.getTablename()));
        }
    }

    @Override
    public void afterOperation(DbTableOperationInfo operationInfo, DataTableQuery query, Collection<TableColumn> columns, DataRow row) throws SystemException {
        if (operationInfo.getOperationType() == DbTableOperationType.UPDATE) {
            this.afterUpdateOperation(operationInfo, query);
        } else if (operationInfo.getOperationType() == DbTableOperationType.INSERT) {
            this.afterInsertOperation(operationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterInsertOperation(DbTableOperationInfo operationInfo) throws SystemException {
        boolean labelDefFound = false;
        for (LabelDefInfo labelInfo : this.labelsUtil.getLabelInfos()) {
            if (!labelInfo.isAuto_place() || !labelInfo.isActive()) continue;
            labelDefFound = true;
            break;
        }
        if (!labelDefFound) {
            return;
        }
        try {
            FeatureReader<SimpleFeatureType, SimpleFeature> frInserted;
            block13: {
                DataTableQuery queryInsertedFeature = new DataTableQuery(this.parentTable.getConnectionInfo(), String.format("%s=?", this.parentTable.getIDColumn()), operationInfo.getDbTable().getIDLastInsert());
                frInserted = this.parentTable.getFeatureReader(operationInfo.getConnInUse(), queryInsertedFeature);
                try {
                    if (frInserted.hasNext()) {
                        SimpleFeature newLabelFeature = (SimpleFeature)frInserted.next();
                        for (LabelDefInfo labelInfo : this.labelsUtil.getLabelInfos()) {
                            SimpleFeature labelFeature;
                            if (!labelInfo.isAuto_place() || !labelInfo.isActive() || (labelFeature = this.labelsUtil.createLabel(labelInfo, newLabelFeature)) == null) continue;
                            this.labelTable.insertFeature(operationInfo.getConnInUse(), labelFeature);
                        }
                        break block13;
                    }
                    throw new SystemException(String.format("Parent feature not found. Error querying inserted features for table '%s' for label adjustment.", this.parentTable.getTablename()));
                }
                catch (Throwable throwable) {
                    try {
                        frInserted.close();
                    }
                    catch (Exception e) {
                        LOG.warn(String.format("Should never reach here. Error querying inserted features for table '%s' for label adjustment.", this.parentTable.getTablename()));
                    }
                    throw throwable;
                }
            }
            try {
                frInserted.close();
            }
            catch (Exception e) {
                LOG.warn(String.format("Should never reach here. Error querying inserted features for table '%s' for label adjustment.", this.parentTable.getTablename()));
            }
        }
        catch (SystemException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SystemException(String.format("Error creating labels after insert in table '%s'", this.parentTable.getTablename()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void afterUpdateOperation(DbTableOperationInfo operationInfo, DataTableQuery query) throws SystemException {
        boolean labelDefFound = false;
        for (LabelDefInfo labelInfo : this.labelsUtil.getLabelInfos()) {
            if (!labelInfo.isActive()) continue;
            labelDefFound = true;
            break;
        }
        if (!labelDefFound) {
            return;
        }
        FeatureReader<SimpleFeatureType, SimpleFeature> frUpdated = this.parentTable.getFeatureReader(operationInfo.getConnInUse(), query);
        try {
            block17: while (true) {
                ArrayList<SimpleFeature> labels2Update;
                ArrayList<SimpleFeature> labels2Delete;
                FeatureReader<SimpleFeatureType, SimpleFeature> frLabels;
                SimpleFeature updatedFeature;
                block27: {
                    block26: {
                        if (!frUpdated.hasNext()) break block26;
                        updatedFeature = (SimpleFeature)frUpdated.next();
                        Object idUpdated = this.parentTable.getIDColumn().parseObject(FeatureUtil.getFeatureIDWithoutTable((SimpleFeature)updatedFeature));
                        DataTableQuery queryLabels = new DataTableQuery(this.labelTable.getConnectionInfo(), String.format("%s=?", LabelFeatureAtts.FID_PARENT.getName()), idUpdated);
                        frLabels = this.labelTable.getFeatureReader(operationInfo.getConnInUse(), queryLabels);
                        labels2Delete = new ArrayList<SimpleFeature>();
                        labels2Update = new ArrayList<SimpleFeature>();
                        try {}
                        catch (Throwable throwable) {
                            try {
                                frLabels.close();
                                throw throwable;
                            }
                            catch (Exception e) {
                                LOG.warn(String.format("Should never reach here. Error querying label features for table '%s' for label adjustment. ", this.parentTable.getTablename()));
                            }
                            throw throwable;
                        }
                        break block27;
                    }
                    try {
                        frUpdated.close();
                        return;
                    }
                    catch (Exception e) {
                        LOG.warn(String.format("Should never reach here. Error querying updated features for table '%s' for label adjustment. ", this.parentTable.getTablename()));
                        return;
                    }
                }
                while (frLabels.hasNext()) {
                    SimpleFeature labelFeature = (SimpleFeature)frLabels.next();
                    Object labelDefIdObj = FeatureUtil.getAttribute((SimpleFeature)labelFeature, (String)LabelFeatureAtts.LABEL_DEF_ID.getName());
                    if (labelDefIdObj == null) {
                        LOG.warn(String.format("Label without label_def_id found in table '%s'. Label is ignored at parent feature udpate.", this.labelTable.getTablename()));
                        continue;
                    }
                    int labelDefId = ((Number)labelDefIdObj).intValue();
                    LabelDefInfo labelInfo = this.labelsUtil.retrieveLabelInfoForID(labelDefId);
                    if (labelInfo == null) {
                        LOG.warn(String.format("Label with invalid label_def_id '%d' found in table '%s'. Label is ignored at parent feature udpate.", labelDefId, this.labelTable.getTablename()));
                        continue;
                    }
                    if (!labelInfo.isActive()) continue;
                    Geometry parentGeometry = (Geometry)updatedFeature.getDefaultGeometry();
                    Geometry labelGeometry = (Geometry)labelFeature.getDefaultGeometry();
                    if (parentGeometry != null && labelGeometry != null && !labelInfo.isUpdate_text()) continue;
                    LabelFeatureAction action = this.labelsUtil.updateLabelText(labelInfo, updatedFeature, labelFeature);
                    if (action == LabelFeatureAction.DELETE) {
                        labels2Delete.add(labelFeature);
                        continue;
                    }
                    if (parentGeometry != null && labelGeometry == null) {
                        this.labelsUtil.updateLabelGeometry(labelInfo, updatedFeature, labelFeature);
                        action = LabelFeatureAction.UPDATE;
                    }
                    if (action != LabelFeatureAction.UPDATE) continue;
                    labels2Update.add(labelFeature);
                }
                try {
                    frLabels.close();
                }
                catch (Exception e) {
                    LOG.warn(String.format("Should never reach here. Error querying label features for table '%s' for label adjustment. ", this.parentTable.getTablename()));
                }
                for (SimpleFeature f2del : labels2Delete) {
                    this.labelTable.deleteFeature(operationInfo.getConnInUse(), f2del);
                }
                Iterator iterator = labels2Update.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block17;
                    SimpleFeature f2up = (SimpleFeature)iterator.next();
                    this.labelTable.updateFeature(operationInfo.getConnInUse(), f2up);
                }
                break;
            }
        }
        catch (Exception ex) {
            try {
                LOG.warn(String.format("Error updating labels for table '%s' after update. ", this.parentTable.getTablename()));
            }
            catch (Throwable throwable) {
                try {
                    frUpdated.close();
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn(String.format("Should never reach here. Error querying updated features for table '%s' for label adjustment. ", this.parentTable.getTablename()));
                }
                throw throwable;
            }
            try {
                frUpdated.close();
                return;
            }
            catch (Exception e) {
                LOG.warn(String.format("Should never reach here. Error querying updated features for table '%s' for label adjustment. ", this.parentTable.getTablename()));
                return;
            }
        }
    }

    @Override
    public void beforeOperation(DbTableOperationInfo operationInfo, DataTableQuery query, Collection<TableColumn> columns, DataRow row) throws SystemException {
        if (operationInfo.getOperationType() == DbTableOperationType.DELETE) {
            List<Object> ids2Delete = operationInfo.getDbTable().getDataListId(operationInfo.getConnInUse(), query);
            for (Object id2Delete : ids2Delete) {
                String fidParendColumnNameInProperCase = this.labelTable.getColumn(LabelFeatureAtts.FID_PARENT.getName()).getColumnName();
                DataTableQuery queryDelLabels = new DataTableQuery(this.labelTable.getConnectionInfo(), String.format("%s=?", fidParendColumnNameInProperCase), id2Delete);
                this.labelTable.deleteData(operationInfo.getConnInUse(), queryDelLabels);
            }
        }
    }
}

