/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.label;

import de.riwagis.label.LabelDefInfo;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.data.DataRowReader;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.DbTableNameConvention;
import de.riwagis.riwadatatable.table.DefaultTableDefinition;
import de.riwagis.riwadatatable.table.TableDefinition;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.jdbc.ConnectionUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class DbTableLabelDefUtils {
    public static TableDefinition getRiwaLabelDefTableDefinition() {
        DefaultTableDefinition tableDefRiwaLabelDef = new DefaultTableDefinition();
        tableDefRiwaLabelDef.setName("riwa_label_def");
        tableDefRiwaLabelDef.setIdColumn("fid");
        tableDefRiwaLabelDef.setOrder("label_order,label_name");
        tableDefRiwaLabelDef.setUpdate(0);
        tableDefRiwaLabelDef.setDelete(0);
        tableDefRiwaLabelDef.setInsert(0);
        tableDefRiwaLabelDef.setDbTableNameConvention(DbTableNameConvention.LOWERCASE);
        return tableDefRiwaLabelDef;
    }

    public static boolean hasRiwaLabelDefTable(Connection conn) {
        try {
            return ConnectionUtils.tableExists((Connection)conn, (String)"riwa_label_def");
        }
        catch (SQLException se) {
            return false;
        }
    }

    public static Collection<String> getDistinctListOfLabelTables(Connection connOrNull, DbTable riwaLabelDefTable, String parentTableName) throws SystemException {
        HashSet<String> labelTableNames = new HashSet<String>();
        DataRowReader reader = null;
        try {
            DataTableQuery query = new DataTableQuery(riwaLabelDefTable.getConnectionInfo(), String.format("lower(%s)=?", "feature_table"), parentTableName.toLowerCase());
            reader = connOrNull == null ? riwaLabelDefTable.getData(query, new String[0]) : riwaLabelDefTable.getData(connOrNull, query, new String[0]);
            while (reader.hasNext()) {
                DataRow labelInfoRow = (DataRow)reader.next();
                LabelDefInfo labelInfo = DbTableLabelDefUtils.dataRow2LabelDefInfo(labelInfoRow);
                if (labelTableNames.contains(labelInfo.getLabel_table())) continue;
                labelTableNames.add(labelInfo.getLabel_table());
            }
        }
        catch (Exception e) {
            throw new SystemException("Error retrieving lock information: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.closeQuietly();
            }
        }
        return labelTableNames;
    }

    public static List<LabelDefInfo> getRiwaLabelDefInfos(Connection connOrNull, DbTable riwaLabelDefTable, String parentTableName, String labelTableName) throws SystemException {
        ArrayList<LabelDefInfo> labelInfos = new ArrayList<LabelDefInfo>();
        DataRowReader reader = null;
        try {
            DataTableQuery query = new DataTableQuery(riwaLabelDefTable.getConnectionInfo(), String.format("lower(%s)=?", "feature_table"), parentTableName.toLowerCase());
            reader = connOrNull == null ? riwaLabelDefTable.getData(query, new String[0]) : riwaLabelDefTable.getData(connOrNull, query, new String[0]);
            while (reader.hasNext()) {
                DataRow labelInfoRow = (DataRow)reader.next();
                LabelDefInfo labelInfo = DbTableLabelDefUtils.dataRow2LabelDefInfo(labelInfoRow);
                if (!labelTableName.equalsIgnoreCase(labelInfo.getLabel_table())) continue;
                labelInfos.add(labelInfo);
            }
        }
        catch (Exception e) {
            throw new SystemException("Error retrieving lock information: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.closeQuietly();
            }
        }
        return labelInfos;
    }

    private static LabelDefInfo dataRow2LabelDefInfo(DataRow labelInfoRow) {
        return new LabelDefInfo(LabelDefInfo.objectToInteger((Object)labelInfoRow.getData("fid")).intValue(), (String)labelInfoRow.getData("label_order"), (String)labelInfoRow.getData("label_name"), (String)labelInfoRow.getData("example"), (String)labelInfoRow.getData("beanshell"), (String)labelInfoRow.getData("prefix"), (String)labelInfoRow.getData("suffix"), LabelDefInfo.objectToBoolean((Object)labelInfoRow.getData("active")), (String)labelInfoRow.getData("feature_table"), (String)labelInfoRow.getData("feature_table_ori"), (String)labelInfoRow.getData("label_table"), (String)labelInfoRow.getData("label_text_table"), (String)labelInfoRow.getData("label_text_table_atts"), (String)labelInfoRow.getData("label_text_fk"), (String)labelInfoRow.getData("label_geom_table"), (String)labelInfoRow.getData("label_geom_atts"), (String)labelInfoRow.getData("label_geom_fk"), LabelDefInfo.objectToBoolean((Object)labelInfoRow.getData("overwrite_label_text_with_null")), LabelDefInfo.objectToInteger((Object)labelInfoRow.getData("textpos")), LabelDefInfo.objectToDouble((Object)labelInfoRow.getData("orientation")), LabelDefInfo.objectToBoolean((Object)labelInfoRow.getData("relative_ori")), LabelDefInfo.objectToBoolean((Object)labelInfoRow.getData("ori_in_gon")), LabelDefInfo.objectToBoolean((Object)labelInfoRow.getData("relative_pos")), LabelDefInfo.objectToDouble((Object)labelInfoRow.getData("offset_x")), LabelDefInfo.objectToDouble((Object)labelInfoRow.getData("offset_y")), LabelDefInfo.objectToBoolean((Object)labelInfoRow.getData("user_selects_position")), LabelDefInfo.objectToBoolean((Object)labelInfoRow.getData("text_readable_on_layout")), LabelDefInfo.objectToBoolean((Object)labelInfoRow.getData("auto_place")), LabelDefInfo.objectToBoolean((Object)labelInfoRow.getData("update_text")));
    }
}

