/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.label;

import de.riwagis.label.AbstractCRUDLabelsUtil;
import de.riwagis.label.LabelDefInfo;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.jdbc.SingleConnJDBCConnectionManager;
import de.riwagis.riwadatatable.table.DefaultTableDefinition;
import de.riwagis.riwadatatable.table.geotools.FeatureDbTable;
import de.riwagis.riwadatatable.table.geotools.FeatureDbTableImpl;
import java.sql.Connection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.geotools.data.FeatureReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTableCRUDLabelsUtil
extends AbstractCRUDLabelsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DbTableCRUDLabelsUtil.class);
    private final FeatureDbTable parentTable;
    private final FeatureDbTable labelTable;
    private final List<LabelDefInfo> labelInfos;
    private final Connection conn2use;

    public DbTableCRUDLabelsUtil(FeatureDbTable parentTable, FeatureDbTable labelTable, List<LabelDefInfo> labelInfos, Connection conn2use) {
        this.parentTable = parentTable;
        this.labelTable = labelTable;
        this.labelInfos = labelInfos;
        this.conn2use = conn2use;
    }

    public List<LabelDefInfo> getLabelInfos() {
        return this.labelInfos;
    }

    protected LabelDefInfo retrieveLabelInfoForID(int labelID) {
        List labelInfos4Id = this.labelInfos.stream().filter(labelInfo -> labelInfo.getFid() == labelID).collect(Collectors.toList());
        if (labelInfos4Id.size() > 1) {
            throw new IllegalStateException("Should never reach here. Only one label definition per ID should be returned.");
        }
        if (labelInfos4Id.isEmpty()) {
            return null;
        }
        return (LabelDefInfo)labelInfos4Id.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleFeature retrieveLinkedFeature(String typeName, String properties, String fkAttribute, String fid4Filter) throws Exception {
        FeatureReader<SimpleFeatureType, SimpleFeature> fr;
        block10: {
            SimpleFeature simpleFeature;
            String[] columnNames = new String[]{};
            if (StringUtils.isNotEmpty((String)properties)) {
                properties = StringUtils.remove((String)properties, (String)" ");
                columnNames = properties.split(",");
            }
            Object fid4FilterObj = this.parentTable.getIDColumn().parseObject(fid4Filter);
            DataTableQuery query = new DataTableQuery(this.parentTable.getConnectionInfo(), String.format("%s=?", fkAttribute), fid4FilterObj);
            DefaultTableDefinition tableDefLinkedFeature = new DefaultTableDefinition();
            tableDefLinkedFeature.setName(typeName);
            tableDefLinkedFeature.setIdColumn("");
            tableDefLinkedFeature.setUpdate(0);
            tableDefLinkedFeature.setDelete(0);
            tableDefLinkedFeature.setInsert(0);
            tableDefLinkedFeature.setDbTableNameConvention(this.parentTable.getTableDefinition().getDbTableNameConvention());
            FeatureDbTableImpl linkedTable = new FeatureDbTableImpl(tableDefLinkedFeature, new SingleConnJDBCConnectionManager(this.conn2use, this.parentTable.getConnectionInfo()), null, this.parentTable.getUserInfo());
            fr = linkedTable.getFeatureReader(this.conn2use, query, columnNames);
            try {
                if (!fr.hasNext()) break block10;
                simpleFeature = (SimpleFeature)fr.next();
            }
            catch (Throwable throwable) {
                try {
                    fr.close();
                }
                catch (Exception ex) {
                    LOG.warn(String.format("Should never reach here. Error retrieving data of linked label table '%s'. FeatureReader could no be closed.", typeName), (Throwable)ex);
                }
                throw throwable;
            }
            try {
                fr.close();
            }
            catch (Exception ex) {
                LOG.warn(String.format("Should never reach here. Error retrieving data of linked label table '%s'. FeatureReader could no be closed.", typeName), (Throwable)ex);
            }
            return simpleFeature;
        }
        SimpleFeature simpleFeature = null;
        try {
            fr.close();
        }
        catch (Exception ex) {
            LOG.warn(String.format("Should never reach here. Error retrieving data of linked label table '%s'. FeatureReader could no be closed.", typeName), (Throwable)ex);
        }
        return simpleFeature;
    }

    protected SimpleFeatureType retrieveLabelSchema(String labelTypeName) {
        return this.labelTable.getFeatureType();
    }
}

