/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.geom;

import de.riwagis.riwadatatable.columns.GeoColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.jdbc.DBType;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderPriority;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtender;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableOperationInfo;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;

public class DbTableMysqlGeomExtender
extends DbTableExtenderAdapter {
    private final DbTable dbTable;

    public DbTableMysqlGeomExtender(DbTable dbTable) {
        super(DbTableExtenderPriority.NORMAL);
        this.dbTable = dbTable;
    }

    @Override
    public DbTableOperationExtender createOperationExtender(final DbTableOperationType type, Connection conn) throws SystemException {
        if (this.dbTable.getConnectionInfo().getDBType() == DBType.MySQL && this.dbTable.hasGeoColumn() && (type == DbTableOperationType.INSERT || type == DbTableOperationType.UPDATE || type == DbTableOperationType.SELECT)) {
            return new DbTableOperationExtenderAdapter(){

                @Override
                public Collection<String> extendColumns4Operation(DbTableOperationInfo operationInfo, Collection<TableColumn> columns) throws SystemException {
                    ArrayList<String> colNames2Add = new ArrayList<String>(super.extendColumns4Operation(operationInfo, columns));
                    if (type == DbTableOperationType.INSERT) {
                        DbTableMysqlGeomExtender.this.dbTable.getColumnsCollection().forEach(col -> {
                            if (col instanceof GeoColumn && !col.isNullable() && !columns.stream().filter(c -> c.getColumnName().equalsIgnoreCase(col.getColumnName())).findFirst().isPresent()) {
                                colNames2Add.add(col.getColumnName());
                            }
                        });
                    }
                    return colNames2Add;
                }

                @Override
                public DataRow adjustDataRow4Operation(DbTableOperationInfo operationInfo, DataRow row) throws SystemException {
                    if (type == DbTableOperationType.INSERT || type == DbTableOperationType.UPDATE) {
                        DbTableMysqlGeomExtender.this.dbTable.getColumnsCollection().forEach(col -> {
                            if (col instanceof GeoColumn && !col.isNullable() && row.hasColumn(col.getColumnName()) && row.getData(col.getColumnName()) == null) {
                                row.setData(col.getColumnName(), (Object)new GeometryFactory().createGeometryCollection());
                            }
                        });
                    }
                    if (type == DbTableOperationType.SELECT) {
                        row.getColumnsCollection().forEach(column -> {
                            Object geom;
                            if (column instanceof GeoColumn && (geom = row.getData(column.getColumnName())) != null && geom instanceof GeometryCollection && ((GeometryCollection)geom).isEmpty()) {
                                row.setData(column.getColumnName(), null);
                            }
                        });
                    }
                    return row;
                }
            };
        }
        return super.createOperationExtender(type, conn);
    }
}

