/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.encoding;

import de.riwagis.riwadatatable.columns.TextColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.jdbc.DBType;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderPriority;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtender;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableOperationInfo;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.extension.presetvalues.DbTableDefaultPresetColumns;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import org.apache.commons.lang3.StringUtils;

public class DbTableMysqlUTF8ToLatinExtender
extends DbTableExtenderAdapter {
    private static final String REPLACE_NON_LATIN_CHARS_PATTERN = "[^\\p{InBasicLatin}^\\p{InLatin-1Supplement}^\\u20AC]";
    private final DbTable dbTable;

    public DbTableMysqlUTF8ToLatinExtender(DbTable dbTable) {
        super(DbTableExtenderPriority.NORMAL);
        this.dbTable = dbTable;
    }

    @Override
    public DbTableOperationExtender createOperationExtender(final DbTableOperationType type, Connection conn) throws SystemException {
        if ((type == DbTableOperationType.INSERT || type == DbTableOperationType.UPDATE) && this.dbTable.getConnectionInfo().getDBType() == DBType.MySQL && this.dbTable.isMySqlLatinDb()) {
            return new DbTableOperationExtenderAdapter(){

                @Override
                public DataRow adjustDataRow4Operation(DbTableOperationInfo operationInfo, DataRow row) throws SystemException {
                    if (type == DbTableOperationType.INSERT || type == DbTableOperationType.UPDATE) {
                        row.getColumnsCollection().forEach(col -> {
                            String currColValue;
                            if (col instanceof TextColumn && !DbTableDefaultPresetColumns.isDefaultPresetColumn(col.getColumnName()) && StringUtils.isNotEmpty((CharSequence)(currColValue = row.getDataAsString(col.getColumnName())))) {
                                row.setData(col.getColumnName(), (Object)currColValue.replaceAll(DbTableMysqlUTF8ToLatinExtender.REPLACE_NON_LATIN_CHARS_PATTERN, "??"));
                            }
                        });
                    }
                    return row;
                }
            };
        }
        return super.createOperationExtender(type, conn);
    }
}

