/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.dependency;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.data.DataRowReader;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableOperationInfo;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.extension.dependency.DbTableDependencyExtender;
import de.riwagis.util.exception.SystemException;
import java.util.Collection;

public class DbTableDependencyOperationExtender
extends DbTableOperationExtenderAdapter {
    private final DbTableDependencyExtender dependencyExtender;

    DbTableDependencyOperationExtender(DbTableDependencyExtender dependencyExtender) {
        this.dependencyExtender = dependencyExtender;
    }

    @Override
    public void afterOperation(DbTableOperationInfo operationInfo, DataTableQuery query, Collection<TableColumn> columns, DataRow row) throws SystemException {
        if (operationInfo.getOperationType() == DbTableOperationType.INSERT && this.dependencyExtender.isCreateChild()) {
            Object linkObj = operationInfo.getDbTable().getIDLastInsert();
            DbTable childTable = this.dependencyExtender.getDbTableChild();
            DataRow row2insert = new DataRow(new TableColumn[]{childTable.getColumn(this.dependencyExtender.getChildColumnName())}, linkObj);
            childTable.insertData(operationInfo.getConnInUse(), row2insert);
        }
    }

    @Override
    public void beforeOperation(DbTableOperationInfo operationInfo, DataTableQuery query, Collection<TableColumn> columns, DataRow row) throws SystemException {
        block10: {
            try {
                if (operationInfo.getOperationType() != DbTableOperationType.DELETE || !this.dependencyExtender.isDeleteChild()) break block10;
                try (DataRowReader rows2delete = operationInfo.getDbTable().getData(operationInfo.getConnInUse(), query, this.dependencyExtender.getParentColumnName());){
                    while (rows2delete.hasNext()) {
                        DataRow row2delete = (DataRow)rows2delete.next();
                        Object linkObj = row2delete.getData(this.dependencyExtender.getParentColumnName());
                        if (linkObj == null) continue;
                        DataTableQuery queryChild = new DataTableQuery(operationInfo.getDbTable().getConnectionInfo(), String.format("%s=?", this.dependencyExtender.getChildColumnName()), linkObj);
                        this.dependencyExtender.getDbTableChild().deleteData(operationInfo.getConnInUse(), queryChild);
                    }
                }
            }
            catch (SystemException se) {
                throw se;
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
    }
}

