/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension.dependency;

import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderAdapter;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderPriority;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtender;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.extension.dependency.DbTableDependencyOperationExtender;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import org.apache.commons.lang.StringUtils;

public class DbTableDependencyExtender
extends DbTableExtenderAdapter {
    private final DbTable dbTableParent;
    private final String parentColumnName;
    private final DbTable dbTableChild;
    private final String childColumnName;
    private final boolean createChild;
    private final boolean deleteChild;
    private final DbTableDependencyOperationExtender operationExtender;

    public DbTableDependencyExtender(DbTable dbTableParent, DbTable dbTableChild, String parentColumnName, String childColumnName, boolean createChild, boolean deleteChild) throws SystemException {
        super(DbTableExtenderPriority.NORMAL);
        this.dbTableParent = dbTableParent;
        this.dbTableChild = dbTableChild;
        this.parentColumnName = StringUtils.defaultIfBlank((String)parentColumnName, (String)dbTableParent.getIDColumn().getColumnName());
        this.childColumnName = childColumnName;
        this.createChild = createChild;
        this.deleteChild = deleteChild;
        this.operationExtender = new DbTableDependencyOperationExtender(this);
        if (!dbTableParent.hasIDColumn() || !dbTableChild.hasIDColumn()) {
            throw new SystemException(String.format("Parent table '%s' and child table '%s' have to have a PrimaryKey column to work with dependencies.", dbTableParent.getTablename(), dbTableChild.getTablename()));
        }
        if (!this.columnsExists()) {
            Object colsNotFound = "";
            if (!dbTableParent.hasColumn(parentColumnName)) {
                colsNotFound = (String)colsNotFound + dbTableParent.getTablename() + "." + parentColumnName;
            }
            if (!dbTableChild.hasColumn(childColumnName)) {
                if (((String)colsNotFound).length() > 0) {
                    colsNotFound = (String)colsNotFound + ", ";
                }
                colsNotFound = (String)colsNotFound + dbTableChild.getTablename() + "." + childColumnName;
            }
            throw new SystemException(String.format("Table dependency columns %s not found.", colsNotFound));
        }
        if (createChild) {
            if (!dbTableParent.getIDColumn().getColumnName().equalsIgnoreCase(parentColumnName)) {
                throw new SystemException(String.format("Automatic insertion of childs in table '%s' is only possible if link column '%s' from parent table '%s' is the PrimaryKey column.", dbTableChild.getTablename(), parentColumnName, dbTableParent.getTablename()));
            }
            if (dbTableChild.getIDColumn().getColumnName().equalsIgnoreCase(childColumnName)) {
                throw new SystemException(String.format("Automatic insertion of datasets in table '%s' not only possible when link column '%s' is the PrimaryKey column.", dbTableChild.getTablename(), childColumnName));
            }
        }
    }

    private boolean columnsExists() {
        return this.dbTableParent.hasColumn(this.parentColumnName) && this.dbTableChild.hasColumn(this.childColumnName);
    }

    @Override
    public DbTableOperationExtender createOperationExtender(DbTableOperationType type, Connection conn) {
        return this.operationExtender;
    }

    public DbTable getDbTableParent() {
        return this.dbTableParent;
    }

    public String getParentColumnName() {
        return this.parentColumnName;
    }

    public DbTable getDbTableChild() {
        return this.dbTableChild;
    }

    public String getChildColumnName() {
        return this.childColumnName;
    }

    public boolean isCreateChild() {
        return this.createChild;
    }

    public boolean isDeleteChild() {
        return this.deleteChild;
    }
}

