/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension;

public enum DbTableOperationType {
    SELECT("select", 1),
    UPDATE("update", 2),
    INSERT("insert", 3),
    DELETE("delete", 4),
    UNKNOWN("", 0);

    private final String queryStart;
    private final int numericValue;

    public static DbTableOperationType byNumValue(int aInt) {
        for (DbTableOperationType currType : DbTableOperationType.values()) {
            if (currType.getNumericValue() != aInt) continue;
            return currType;
        }
        return UNKNOWN;
    }

    private DbTableOperationType(String queryStart, int numericValue) {
        this.queryStart = queryStart;
        this.numericValue = numericValue;
    }

    public String getQueryStart() {
        return this.queryStart;
    }

    public int getNumericValue() {
        return this.numericValue;
    }

    public boolean isOneOf(DbTableOperationType ... checkOpTypes) {
        for (DbTableOperationType currType : checkOpTypes) {
            if (currType != this) continue;
            return true;
        }
        return false;
    }
}

