/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.extension;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtender;
import de.riwagis.riwadatatable.table.extension.DbTableOperationInfo;
import de.riwagis.util.exception.SystemException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class DbTableOperationExtenderCollectionProxy
implements DbTableOperationExtender {
    private final Collection<DbTableOperationExtender> operationExtenders;

    public DbTableOperationExtenderCollectionProxy(Collection<DbTableOperationExtender> operationExtenders) {
        this.operationExtenders = new ArrayList<DbTableOperationExtender>(operationExtenders);
    }

    @Override
    public Collection<String> extendColumns4Operation(DbTableOperationInfo operationInfo, Collection<TableColumn> columns) throws SystemException {
        HashSet<String> colNames2Add = new HashSet<String>();
        for (DbTableOperationExtender operationExtender : this.operationExtenders) {
            colNames2Add.addAll(operationExtender.extendColumns4Operation(operationInfo, columns));
        }
        return colNames2Add;
    }

    @Override
    public DataRow adjustDataRow4Operation(DbTableOperationInfo operationInfo, DataRow row) throws SystemException {
        DataRow adjustedRow = row;
        for (DbTableOperationExtender operationExtender : this.operationExtenders) {
            adjustedRow = operationExtender.adjustDataRow4Operation(operationInfo, adjustedRow);
        }
        return adjustedRow;
    }

    @Override
    public DataTableQuery adjustFilter4Operation(DbTableOperationInfo operationInfo, DataTableQuery query, Collection<TableColumn> columns, DataRow row) throws SystemException {
        DataTableQuery adjustedQuery = query;
        for (DbTableOperationExtender operationExtender : this.operationExtenders) {
            adjustedQuery = operationExtender.adjustFilter4Operation(operationInfo, adjustedQuery, columns, row);
        }
        return adjustedQuery;
    }

    @Override
    public String isOperationAllowed(DbTableOperationInfo operationInfo, DataTableQuery query, Collection<TableColumn> columns, DataRow row) throws SystemException {
        Object errorText = null;
        for (DbTableOperationExtender operationExtender : this.operationExtenders) {
            String errorTextSingle = operationExtender.isOperationAllowed(operationInfo, query, columns, row);
            if (errorTextSingle == null) continue;
            if (StringUtils.isBlank(errorText)) {
                errorText = errorTextSingle;
                continue;
            }
            errorText = (String)errorText + "\n" + errorTextSingle;
        }
        return errorText;
    }

    @Override
    public void beforeOperation(DbTableOperationInfo operationInfo, DataTableQuery query, Collection<TableColumn> columns, DataRow row) throws SystemException {
        for (DbTableOperationExtender operationExtender : this.operationExtenders) {
            operationExtender.beforeOperation(operationInfo, query, columns, row);
        }
    }

    @Override
    public void afterOperation(DbTableOperationInfo operationInfo, DataTableQuery query, Collection<TableColumn> columns, DataRow row) throws SystemException {
        for (DbTableOperationExtender operationExtender : this.operationExtenders) {
            operationExtender.afterOperation(operationInfo, query, columns, row);
        }
    }

    @Override
    public void close() throws Exception {
        for (DbTableOperationExtender operationExtender : this.operationExtenders) {
            operationExtender.close();
        }
    }
}

