/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table.batch;

import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.NumberColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.data.DataRowReader;
import de.riwagis.riwadatatable.data.DataRowUtils;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.sequence.TableSequenceHandler;
import de.riwagis.riwadatatable.sequence.TableSequenceHandlerUtils;
import de.riwagis.riwadatatable.table.DbTableConnectionHandler;
import de.riwagis.riwadatatable.table.DbTableImpl;
import de.riwagis.riwadatatable.table.DbTableOperationHandler;
import de.riwagis.riwadatatable.table.DbTableUtils;
import de.riwagis.riwadatatable.table.TableDefinition;
import de.riwagis.riwadatatable.table.batch.BatchDbTable;
import de.riwagis.riwadatatable.table.extension.DbTableExtender;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.userinfo.DbTableUserInfo;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;

public class BatchDbTableImpl
extends DbTableImpl
implements BatchDbTable {
    private int batchSize;

    public BatchDbTableImpl(TableDefinition tblDef, JDBCConnectionManager connMngr, Collection<DbTableExtender> extenders, DbTableUserInfo userInfo, int batchSize) throws SystemException {
        super(tblDef, connMngr, extenders, userInfo);
        this.batchSize = batchSize;
    }

    @Override
    public int insertDataAsBatch(Connection conn, DataRowReader rows2Insert) throws SystemException {
        this.assertInsertable();
        int intAnzahl = 0;
        try (DbTableOperationHandler oph = this.getExtenderHandler().createOperationHandler(DbTableOperationType.INSERT, conn);){
            TableSequenceHandler tsl = this.createTableSequenceHandler();
            DataRow readerRow = this.retrieveTableSpecificDataRow(new DataRow(rows2Insert.getColumnsCollection(), Arrays.asList(new Object[rows2Insert.getColumnCount()])));
            this.prepareDataRowForInsert(conn, oph, tsl, readerRow);
            String sqlInsert = DbTableUtils.buildInsertSQL4Columns(this.getTablename(), readerRow.getColumnsCollection(), this.getConnectionInfo().getDBType());
            try (PreparedStatement pstmt = TableSequenceHandlerUtils.buildPreparedInsertStatement4Insert(conn, sqlInsert, tsl);){
                int currentBatchCount = 0;
                int operationsCount = 0;
                while (rows2Insert.hasNext()) {
                    DataRow data2Insert = this.retrieveTableSpecificDataRow((DataRow)rows2Insert.next());
                    this.prepareDataRowForInsert(conn, oph, tsl, data2Insert);
                    this.addBatchToPreparedStatement(oph, pstmt, data2Insert);
                    ++operationsCount;
                    if (++currentBatchCount != this.batchSize) continue;
                    intAnzahl += this.insertDataBatch(conn, pstmt, tsl);
                    currentBatchCount = 0;
                    operationsCount = this.handleCommitEveryDataRowReaderOperation(conn, operationsCount);
                }
                if (currentBatchCount > 0) {
                    intAnzahl += this.insertDataBatch(conn, pstmt, tsl);
                    currentBatchCount = 0;
                }
            }
        }
        catch (Throwable t) {
            throw this.convertThrowable2SystemException(t, conn, String.format("Error inserting data in table %s.%s", this.getTableScheme(), this.getTablename()));
        }
        return intAnzahl;
    }

    @Override
    public int insertDataAsBatch(DataRowReader rows2Insert) throws SystemException {
        DbTableConnectionHandler connHndl = this.createDbTableConnectionHandler();
        try {
            int intAnzahl = this.insertDataAsBatch(connHndl.getConnection(), rows2Insert);
            connHndl.commitIfAutocommit();
            int n = intAnzahl;
            return n;
        }
        catch (Throwable e) {
            connHndl.closeConnectionAfterExceptionQuietly();
            if (e instanceof SystemException) {
                throw (SystemException)e;
            }
            throw new SystemException(this.getClass(), e);
        }
        finally {
            connHndl.closeConnectionQuietly();
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    protected int insertDataBatch(Connection conn, PreparedStatement pstmt, TableSequenceHandler tsl) throws SystemException {
        int rowsInserted = 0;
        try {
            int[] rowsInsertedArr = pstmt.executeBatch();
            rowsInserted = IntStream.of(rowsInsertedArr).sum();
            if (rowsInserted == 0) {
                throw new SystemException("No data could be inserted in table.");
            }
            try {
                this.objIDLastInsert = tsl.retrieveLastID(pstmt);
            }
            catch (Exception e) {
                this.objIDLastInsert = null;
            }
            if (this.hasIDColumn() && this.getIDColumn().getType() == ColumnTypes.CT_NUMBER_COLUMN && this.objIDLastInsert != null) {
                this.objIDLastInsert = ((NumberColumn)this.getIDColumn()).getNumberType().numberOfType((Number)this.objIDLastInsert, this.getIDColumn().isUnsigned());
            }
            pstmt.clearBatch();
        }
        catch (Throwable t) {
            SystemException sysex = this.convertThrowable2SystemException(t, conn, String.format("Error inserting data in table %s.%s", this.getTableScheme(), this.getTablename()));
            this.getExceptionHandler().handleException(DbTableOperationType.INSERT, conn, sysex);
        }
        return rowsInserted;
    }

    protected void addBatchToPreparedStatement(DbTableOperationHandler oph, PreparedStatement pstmt, DataRow data2Insert) throws SystemException, SQLException {
        data2Insert = oph.adjustDataRow4Operation(DbTableOperationType.INSERT, pstmt.getConnection(), data2Insert, null);
        oph.checkAllowed(DbTableOperationType.INSERT, pstmt.getConnection(), data2Insert.getColumnsCollection(), data2Insert, null);
        this.validateDataRowThrowingException(data2Insert, DbTableOperationType.INSERT);
        oph.beforeOperation(DbTableOperationType.INSERT, pstmt.getConnection(), data2Insert.getColumnsCollection(), data2Insert, null, -1);
        DataRowUtils.fillPreparedStatementWithDataRow(pstmt, data2Insert);
        pstmt.addBatch();
    }
}

