/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table;

import org.locationtech.jts.geom.Geometry;

public enum SpatialQueryType {
    INTERSECT(0, (geometryToMatch, geometryCandidate) -> geometryToMatch.intersects(geometryCandidate)),
    CONTAINS(1, (geometryToMatch, geometryCandidate) -> geometryToMatch.contains(geometryCandidate)),
    WITHIN(2, (geometryToMatch, geometryCandidate) -> geometryToMatch.within(geometryCandidate)),
    TOUCHES(3, (geometryToMatch, geometryCandidate) -> geometryToMatch.touches(geometryCandidate));

    private final int id;
    private final Matcher matcher;

    private SpatialQueryType(int id, Matcher matcher) {
        this.id = id;
        this.matcher = matcher;
    }

    public int getId() {
        return this.id;
    }

    public boolean match(Geometry geometryToMatch, Geometry geometryCandidate) {
        return this.matcher.matchGeometry(geometryToMatch, geometryCandidate);
    }

    public static SpatialQueryType findById(int spatialQueryTypeID) {
        for (SpatialQueryType currType : SpatialQueryType.values()) {
            if (currType.getId() != spatialQueryTypeID) continue;
            return currType;
        }
        throw new IllegalArgumentException(String.format("Spatial query for ID: %s not found", spatialQueryTypeID));
    }

    private static interface Matcher {
        public boolean matchGeometry(Geometry var1, Geometry var2);
    }
}

