/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table;

import de.riwagis.riwadatatable.table.DbTableNameConvention;
import de.riwagis.riwadatatable.table.TableDefinition;

public class DefaultTableDefinition
implements TableDefinition {
    private String name = "";
    private String idColumn = "";
    private String filter = "";
    private String order = "";
    private String strDefault = "";
    private String selectname = "";
    private String seq = "";
    private int insert = 0;
    private int update = 0;
    private int delete = 0;
    private String deleteCondition = "";
    private String lockColumn = "locked_by_id";
    private int changelog = 2;
    private int selectlog = 0;
    private DbTableNameConvention dbTableNameConvention = DbTableNameConvention.LOWERCASE;

    public DefaultTableDefinition() {
    }

    public DefaultTableDefinition(String name, String idColumn, String seq, String order) {
        this.name = name;
        this.idColumn = idColumn;
        this.seq = seq;
        this.order = order;
        this.insert = 1;
        this.update = 1;
        this.delete = 1;
    }

    public DefaultTableDefinition(TableDefinition copyFrom) {
        this.name = copyFrom.getName();
        this.idColumn = copyFrom.getIdColumn();
        this.lockColumn = copyFrom.getLockColumn();
        this.filter = copyFrom.getFilter();
        this.order = copyFrom.getOrder();
        this.strDefault = copyFrom.getStrDefault();
        this.selectname = copyFrom.getSelectname();
        this.seq = copyFrom.getSeq();
        this.insert = copyFrom.getInsert();
        this.update = copyFrom.getUpdate();
        this.delete = copyFrom.getDelete();
        this.deleteCondition = copyFrom.getDeleteCondition();
        this.changelog = copyFrom.getChangelog();
        this.selectlog = copyFrom.getSelectlog();
        this.dbTableNameConvention = copyFrom.getDbTableNameConvention();
    }

    public DefaultTableDefinition(String name, String idColumn, String seq, String deleteCondition, String filter, String order, boolean update, boolean insert, boolean delete) {
        this.name = name;
        this.idColumn = idColumn;
        this.seq = seq;
        this.deleteCondition = deleteCondition;
        this.filter = filter;
        this.order = order;
        this.update = update ? 1 : 0;
        this.insert = insert ? 1 : 0;
        this.delete = delete ? 1 : 0;
    }

    @Override
    public DbTableNameConvention getDbTableNameConvention() {
        return this.dbTableNameConvention;
    }

    public void setDbTableNameConvention(DbTableNameConvention dbTableNameConvention) {
        this.dbTableNameConvention = dbTableNameConvention;
    }

    public String toString() {
        return String.format("table definition for '%s'", this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getIdColumn() {
        return this.idColumn;
    }

    public void setIdColumn(String idColumn) {
        this.idColumn = idColumn;
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    @Override
    public String getStrDefault() {
        return this.strDefault;
    }

    public void setStrDefault(String strDefault) {
        this.strDefault = strDefault;
    }

    @Override
    public String getSelectname() {
        return this.selectname;
    }

    public void setSelectname(String selectname) {
        this.selectname = selectname;
    }

    @Override
    public String getSeq() {
        return this.seq;
    }

    public void setSeq(String seq) {
        this.seq = seq;
    }

    @Override
    public int getInsert() {
        return this.insert;
    }

    public void setInsert(int insert) {
        this.insert = insert;
    }

    @Override
    public int getUpdate() {
        return this.update;
    }

    public void setUpdate(int update) {
        this.update = update;
    }

    @Override
    public int getDelete() {
        return this.delete;
    }

    public void setDelete(int delete) {
        this.delete = delete;
    }

    @Override
    public String getDeleteCondition() {
        return this.deleteCondition;
    }

    public void setDeleteCondition(String deleteCondition) {
        this.deleteCondition = deleteCondition;
    }

    @Override
    public String getLockColumn() {
        return this.lockColumn;
    }

    public void setLockColumn(String lockColumn) {
        this.lockColumn = lockColumn;
    }

    @Override
    public int getChangelog() {
        return this.changelog;
    }

    public void setChangelog(int changelog) {
        this.changelog = changelog;
    }

    @Override
    public int getSelectlog() {
        return this.selectlog;
    }

    public void setSelectlog(int selectlog) {
        this.selectlog = selectlog;
    }
}

