/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table;

import de.riwagis.riwadatatable.columns.ColumnUtils;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.jdbc.DBType;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.table.TableDefinition;
import de.riwagis.util.jdbc.JDBCSupport;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTableUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DbTableUtils.class);

    public static String formatOrderBy(String strOrder2Check, String tableIDColumn) {
        Object orderbyRes = StringUtils.trim((String)strOrder2Check);
        if (StringUtils.isNotBlank((String)orderbyRes)) {
            if (((String)orderbyRes).indexOf(40) == -1) {
                LinkedHashSet<String> orderByColumns = new LinkedHashSet<String>();
                for (String currOrderColumn : strOrder2Check.split(",")) {
                    String fullColumnName = String.format("%s%s", currOrderColumn.indexOf(46) >= 0 ? "" : "tbl.", currOrderColumn.trim());
                    orderByColumns.add(fullColumnName);
                }
                orderbyRes = StringUtils.join(orderByColumns, (String)", ");
            }
        } else if (StringUtils.isNotBlank((String)tableIDColumn)) {
            orderbyRes = "tbl." + tableIDColumn;
        }
        return orderbyRes;
    }

    public static String buildInsertSQL4Columns(String tableName, Collection<TableColumn> columns, DBType dbType) {
        if (columns.isEmpty()) {
            if (dbType == DBType.Postgres || dbType == DBType.MSSQLServer) {
                return String.format("insert into %s DEFAULT VALUES", tableName);
            }
            if (dbType == DBType.Oracle) {
                throw new IllegalArgumentException("Should never reach here. Empty column list in insert statement is not supported on oracle.");
            }
        }
        Collection<String> columnNames = ColumnUtils.listColumnNames(columns);
        ArrayList<String> valuesList = new ArrayList<String>();
        for (TableColumn col : columns) {
            valuesList.add(col.getInsertString());
        }
        StringBuilder sbSQL = new StringBuilder();
        sbSQL.append("INSERT INTO ");
        sbSQL.append(tableName);
        sbSQL.append(" (").append(StringUtils.join(columnNames, (String)", ")).append(")");
        sbSQL.append(" VALUES ");
        sbSQL.append(" (").append(StringUtils.join(valuesList, (String)", ")).append(")");
        return sbSQL.toString();
    }

    public static String buildUpdateSQL4ColumnsAndQuery(String tableName, String defaultValues, Collection<TableColumn> columns, DataTableQuery query) {
        StringBuilder sbSQL = new StringBuilder();
        sbSQL.append("UPDATE ");
        sbSQL.append(tableName);
        sbSQL.append(" SET ");
        if (StringUtils.isNotBlank((String)defaultValues)) {
            sbSQL.append(defaultValues).append(" ");
        }
        ArrayList<String> updateAssignements = new ArrayList<String>();
        for (TableColumn col : columns) {
            updateAssignements.add(String.format("%s=%s", col.getColumnName(), col.getUpdateString()));
        }
        if (StringUtils.isNotBlank((String)defaultValues) && !updateAssignements.isEmpty()) {
            sbSQL.append(", ");
        }
        sbSQL.append(StringUtils.join(updateAssignements, (String)", "));
        if (!query.isEmpty()) {
            sbSQL.append(" WHERE ").append(query.getSQLWhere());
        }
        return sbSQL.toString();
    }

    public static String buildDeleteSQL4Query(String tableName, DataTableQuery query) {
        StringBuilder sbSQL = new StringBuilder();
        sbSQL.append("DELETE FROM ");
        sbSQL.append(tableName);
        if (!query.isEmpty()) {
            sbSQL.append(" WHERE ").append(query.getSQLWhere());
        }
        return sbSQL.toString();
    }

    protected static void setAutoCommitQuietly(Connection conn, boolean autoCommit) {
        JDBCSupport.setAutoCommitQuietly((Connection)conn, (boolean)autoCommit);
    }

    public static void commitQuietly(Connection conn) {
        try {
            conn.commit();
        }
        catch (Throwable t) {
            LOG.warn(String.format("unable to commit connection: %s", t.getMessage()), t);
        }
    }

    public static void rollbackQuietly(Connection conn, Savepoint sp) {
        try {
            if (sp == null) {
                conn.rollback();
            } else {
                conn.rollback(sp);
            }
        }
        catch (Throwable t) {
            LOG.warn(String.format("unable to rollback connection: %s", t.getMessage()), t);
        }
    }

    public static boolean tryUpdateQuery(Connection conn, String execQuery) {
        boolean bl;
        block8: {
            PreparedStatement stmt = conn.prepareStatement(execQuery);
            try {
                stmt.executeUpdate();
                bl = true;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.debug(String.format("failed to execute query '%s': %s", execQuery, e.getMessage()), (Throwable)e);
                    return false;
                }
            }
            stmt.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasUserMSSQLPermission(Connection conn, String tableName, String action) {
        try (PreparedStatement stmt = conn.prepareStatement("SELECT HAS_PERMS_BY_NAME(?,?,?)");){
            stmt.setString(1, (conn.getSchema() + "." + tableName).toLowerCase());
            stmt.setString(2, "OBJECT");
            stmt.setString(3, action.toUpperCase());
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return false;
                boolean bl = rs.getInt(1) == 1;
                return bl;
            }
        }
        catch (SQLException ex) {
            LOG.debug(String.format("failed to execute query '%s': %s", "SELECT HAS_PERMS_BY_NAME()", ex.getMessage()), (Throwable)ex);
        }
        return false;
    }

    @Deprecated
    public static final String buildQuery(TableDefinition tableDefinition, Collection<TableColumn> columns, DataTableQuery query, String orderBy) {
        return DbTableUtils.buildQuery(null, tableDefinition, columns, query, orderBy);
    }

    public static final String buildQuery(JDBCConnectionInfo connInfo, TableDefinition tableDefinition, Collection<TableColumn> columns, DataTableQuery query, String orderBy) {
        StringBuilder sbSQL = new StringBuilder();
        sbSQL.append("SELECT ");
        sbSQL.append(DbTableUtils.buildLimitExpressionAfterSelect(connInfo, query.getLimit()));
        sbSQL.append(StringUtils.join(ColumnUtils.listColumnSelectStrings(columns), (String)","));
        sbSQL.append(" FROM ");
        sbSQL.append(tableDefinition.getSelectname());
        sbSQL.append(' ');
        sbSQL.append("tbl");
        sbSQL.append(' ');
        sbSQL.append(query.getSQLWhere(true));
        sbSQL.append(' ');
        sbSQL.append(StringUtils.defaultIfEmpty((String)orderBy, (String)""));
        sbSQL.append(DbTableUtils.buildLimitExpressionToAppend(connInfo, query.getLimit()));
        return sbSQL.toString();
    }

    public static String buildLimitExpressionAfterSelect(JDBCConnectionInfo connInfo, int maxResults) {
        if (maxResults > 0 && maxResults != Integer.MAX_VALUE && connInfo != null && connInfo.isMSSQLServer()) {
            return String.format(" TOP %d ", maxResults);
        }
        return "";
    }

    public static String buildLimitExpressionToAppend(JDBCConnectionInfo connInfo, int maxResults) {
        if (maxResults > 0 && maxResults != Integer.MAX_VALUE) {
            if (connInfo != null && connInfo.isMSSQLServer()) {
                return "";
            }
            if (connInfo != null && connInfo.isOracle()) {
                return String.format(" FETCH FIRST %d ROWS ONLY ", maxResults);
            }
            return String.format(" LIMIT %d ", maxResults);
        }
        return "";
    }

    public static Savepoint setSavepointQuietly(Connection conn) {
        try {
            return conn.setSavepoint();
        }
        catch (SQLException sqlex) {
            LOG.warn("error setting savepoint: " + sqlex.getMessage(), (Throwable)sqlex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isMySqlLatinDatabase(JDBCConnectionInfo connInfo, Connection conn) {
        if (connInfo.getDBType() != DBType.MySQL) return false;
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("select @@character_set_database");){
            if (!rs.next()) return false;
            boolean bl = rs.getString(1).contains("latin1");
            return bl;
        }
        catch (Exception ex) {
            LOG.warn("error getting mysql character_set information occured", (Throwable)ex);
        }
        return false;
    }
}

